PY2_LIBRARY()

OWNER(g:rasp-back)

PEERDIR(
    contrib/python/protobuf
    contrib/python/beautifulsoup4
    contrib/python/django/django-1.11
    contrib/python/django-debug-toolbar
    contrib/python/django-filebrowser-no-grappelli
    contrib/python/django-jinja
    contrib/python/inflect
    contrib/python/ipython
    contrib/python/psutil
    contrib/python/six
    contrib/python/Shapely
    contrib/python/Wand
    contrib/python/Werkzeug
    contrib/python/xlrd

    library/python/django
    library/python/django-idm-api
    library/python/python-django-yauth
    library/python/yt

    travel/library/python/resource
    travel/library/python/entrypoint

    travel/rasp/admin/tester
    travel/rasp/library/python/hemi
    travel/rasp/library/python/proxy
    travel/rasp/library/python/common
    travel/rasp/library/python/common/apps/facility/migrations
    travel/rasp/library/python/common/apps/suburban_events/migrations
    travel/rasp/library/python/common/apps/train/migrations
    travel/rasp/library/python/common/apps/train_order/migrations
    travel/rasp/library/python/common/maintenance/migrations
    travel/rasp/library/python/geosearch
    travel/rasp/library/python/mapping
    travel/rasp/library/python/mapping/migrations
    #  pathfinder ???
    travel/rasp/library/python/route_search
    travel/rasp/library/python/route_search/migrations
    travel/rasp/library/python/sitemap
    travel/rasp/library/python/stationschedule

    yt/python/client
)

RESOURCE_FILES(
    admin/blue/templates/admin/blue/admin.jhtml
    admin/lime/templates/index.jhtml
    admin/red/templates/red/admin.jhtml
    admin/red/templates/red/import_error_message.jhtml

    admin/templates/admin/base_site.html
    admin/templates/admin/base_station/package_station_list.html
    admin/templates/admin/block_calendar.html
    admin/templates/admin/block_month.html
    admin/templates/admin/block_service_alert.html
    admin/templates/admin/change_form.html
    admin/templates/admin/change_list.html
    admin/templates/admin/coach_schema_widget.html
    admin/templates/admin/dynamic_settings/list.html
    admin/templates/admin/edit_inline/stacked_collapsed.html
    admin/templates/admin/edit_inline/tabular_with_checkboxes_in_head.html
    admin/templates/admin/gtfsconverter/form.html
    admin/templates/admin/importinfo/afdbchangesfile/change_form.html
    admin/templates/admin/importinfo/afotherschedulefile/change_form.html
    admin/templates/admin/importinfo/afschedulefile/change_list.html
    admin/templates/admin/importinfo/afsubwayfile/change_form.html
    admin/templates/admin/importinfo/afsubwayfile/change_list.html
    admin/templates/admin/importinfo/aftrainturnoverfile/change_form.html
    admin/templates/admin/importinfo/aftrainturnoverupdatefile/change_form.html
    admin/templates/admin/importinfo/afupdatefile/change_form.html
    admin/templates/admin/importinfo/busstationimportfile/change_form.html
    admin/templates/admin/importinfo/mappingcontext/change_form.html
    admin/templates/admin/importinfo/originalthreaddata/change_form.html
    admin/templates/admin/importinfo/packagedirectionsslice/change_form.html
    admin/templates/admin/importinfo/packagedirectionsslice/compare.html
    admin/templates/admin/importinfo/stationmapping/change_form.html
    admin/templates/admin/importinfo/tarifffile/change_form.html
    admin/templates/admin/importinfo/trianglebusimportpackage/change_form.html
    admin/templates/admin/importinfo/twostageimportpackage/change_form.html
    admin/templates/admin/importinfo/twostageimportthread/change_form.html
    admin/templates/admin/includes/fieldset.html
    admin/templates/admin/includes/fieldset_link.html
    admin/templates/admin/log_list.html
    admin/templates/admin/maintenance.html
    admin/templates/admin/order/partner/change_form.html
    admin/templates/admin/order/partner/track.html
    admin/templates/admin/order/partnerreview/change_list.html
    admin/templates/admin/order/partnerreview/stat.html
    admin/templates/admin/quick_tree.html
    admin/templates/admin/quick_tree_add_obj.html
    admin/templates/admin/quick_tree_nav.html
    admin/templates/admin/red/package/change_form.html
    admin/templates/admin/sindbad_stats.html
    admin/templates/admin/staticpages/staticpage/change_list.html
    admin/templates/admin/suburban_change_notices/noticeemailtemplate/change_form.html
    admin/templates/admin/suburban_change_notices/noticeemailtemplate/send_mass_mail_confirmation.html
    admin/templates/admin/tkvc_converter.html
    admin/templates/admin/upload_railway_file.html
    admin/templates/admin/upload_schedule_file.html
    admin/templates/admin/urban/package/change_form.html
    admin/templates/admin/www/company/change_form.html
    admin/templates/admin/www/company/remove_routes_confirmation.html
    admin/templates/admin/www/companyoffice/change_form.html
    admin/templates/admin/www/country/change_form.html
    admin/templates/admin/www/direction/change_form.html
    admin/templates/admin/www/direction/change_list.html
    admin/templates/admin/www/district/change_form.html
    admin/templates/admin/www/externaldirection/change_form.html
    admin/templates/admin/www/externaldirection/change_list.html
    admin/templates/admin/www/externaldirection/edit_schema.html
    admin/templates/admin/www/load_zip_file_form.html
    admin/templates/admin/www/region/change_form.html
    admin/templates/admin/www/regionwhitelist/change_form.html
    admin/templates/admin/www/route/change_form.html
    admin/templates/admin/www/rthread/change_form.html
    admin/templates/admin/www/rtstation/change_form.html
    admin/templates/admin/www/settlement/change_form.html
    admin/templates/admin/www/settlementimage/change_list.html
    admin/templates/admin/www/settlementimage/change_list_results.html
    admin/templates/admin/www/settlementimage/image_search_popup.html
    admin/templates/admin/www/station/change_form.html
    admin/templates/admin/www/station/change_list.html
    admin/templates/admin/www/suburbanzone/change_form.html
    admin/templates/admin/www/suburbanzone/change_list.html
    admin/templates/admin/www/trainpseudostationmap/change_list.html
    admin/templates/admin/www/trainpseudostationmap/load_map.html
    admin/templates/admin/www/transportmodel/change_form.html
    admin/templates/filebrowser/detail.html
    admin/templates/raspadmin/includes/task_log_blocks.html
    admin/templates/raspadmin/ott_load_stations.html
    admin/templates/raspadmin/tanker_action.html
    admin/templates/mds_files_viewer/listing.html
)

RESOURCE_FILES(
    PREFIX travel/rasp/admin/
    importinfo/fixtures/importinfo_afmasktext_initial.json
)

RESOURCE_FILES(
    cysix/fixtures/cysix_filter_initial.json
)

# TODO: just for list potential usefull files: don't extract and don't work for tests because extracts PROJECT_PATH with prefixes travel/rasp/admin
# TODO: move to resource if possible
RESOURCE_FILES( PREFIX scripts_env/travel/rasp/admin/
# TODO: add if neccesary or delete after
#    www/db/scripts/data/airports_en_titles
#    www/db/scripts/data/firm_trains/firmennye__belarus.csv
#    www/db/scripts/data/firm_trains/firmennye__kazakhstan.csv
#    www/db/scripts/data/firm_trains/firmennye__ukraina.csv
#    www/db/scripts/data/firm_trains/firmennye_poezda.csv
#    www/db/scripts/data/partners_response_cache/README
#    www/db/scripts/data/pathfinder/README
    www/db/scripts/data/pathfinder/station_teleport.map
    www/db/scripts/data/schedule/udmbus/replace_arrival.csv
    www/db/scripts/data/special_offer_trevel.xml
    www/db/scripts/data/subway/passages.csv
    www/db/scripts/data/subway/stations.csv
    www/db/scripts/data/subway/subway.csv
    www/db/scripts/data/subway/threads.xml
#    www/db/scripts/data/ticketoffices/Avia i zh.d. kassy - Kurgan, Kemerovo, Samara.csv
#    www/db/scripts/data/ticketoffices/Ekaterinburg.csv
#    www/db/scripts/data/ticketoffices/Piter-1.csv
#    www/db/scripts/data/ticketoffices/aiva i zh(d kassy Kazan_.csv
#    www/db/scripts/data/ticketoffices/avia i zh(d kassy Ekaterinburg.csv
#    www/db/scripts/data/ticketoffices/avia i zh(d kassy Ufa.csv
#    www/db/scripts/data/ticketoffices/avia i zh(d kassy chelyabinsk.csv
#    www/db/scripts/data/ticketoffices/avia i zh.d. kassy - Novosibirska.csv
#    www/db/scripts/data/ticketoffices/avia i zh.d. kassy Moskva.csv
#    www/db/scripts/data/ticketoffices/avia i zh.d. kassy Piter.csv
#    www/db/scripts/data/ticketoffices/synonims.csv
#    www/db/scripts/data/ticketoffices/synonyms.csv
#    www/db/scripts/data/tmp/README
#    www/db/scripts/data/transfers_test_directions.csv
#    www/db/scripts/data/upload/README
#    www/db/scripts/data/weather.y.rss
)

RESOURCE(
    cysix/data/public.xsd cysix/data/public.xsd
    cysix/data/public.rst cysix/data/public.rst

    www/db/scripts/data/schedule/mta/mtastop3.csv www/db/scripts/data/schedule/mta/mtastop3.csv
    www/db/scripts/data/geobase_populations.tsv.gz www/db/scripts/data/geobase_populations.tsv.gz
)

PY_SRCS(
    app.py
)

PY_SRCS(
    admin/__init__.py
    admin/admin/__init__.py
    admin/admin/route_search_admin.py
    admin/admin_tasks.py
)

PY_SRCS( TOP_LEVEL
    admin/apps.py
)

PY_SRCS(
    admin/blue/__init__.py
    admin/blue/api.py
    admin/blue/convertors.py
    admin/blue/urls.py
    admin/blue/views.py

    admin/context_processors.py

    admin/lime/__init__.py
    admin/lime/urls.py
    admin/lime/views.py

    admin/maintenance_settings/__init__.py
    admin/maintenance_settings/admin.py
    admin/maintenance_settings/migrations/0001_initial.py
    admin/maintenance_settings/migrations/0002_script_order.py
    admin/maintenance_settings/migrations/0003_remove_script_on_migration.py
    admin/maintenance_settings/migrations/__init__.py
    admin/maintenance_settings/models.py
)

# special django directory
PY_SRCS( TOP_LEVEL
    admin/management/__init__.py
    admin/management/commands/__init__.py
    admin/management/commands/runtask.py
)

PY_SRCS(
    admin/middleware/__init__.py
    admin/middleware/idm_tvm.py
    admin/middleware/on_switch_db.py

    admin/models.py

    admin/modules/__init__.py
    admin/modules/zone_reimport.py

    admin/purple/__init__.py
    admin/purple/api.py
    admin/purple/urls.py
    admin/purple/views.py

    admin/red/__init__.py
    admin/red/admin.py
    admin/red/api.py
    admin/red/cartesian.py
    admin/red/convertors.py
    admin/red/forms.py
    admin/red/metaimport.py
    admin/red/migrations/0001_initial.py
    admin/red/migrations/0002_package_last_import_datetime.py
    admin/red/migrations/__init__.py
    admin/red/models.py
    admin/red/scheme.py
    admin/red/urls.py
    admin/red/views.py

    admin/reports/__init__.py
    admin/reports/urls.py
    admin/reports/views.py
)

# special django directory
PY_SRCS( TOP_LEVEL
    admin/templatetags/__init__.py
    admin/templatetags/admin_alerts.py
    admin/templatetags/admin_foreign_objects.py
    admin/templatetags/admin_opts.py
    admin/templatetags/get_klass.py
)

PY_SRCS(
    admin/urls.py
    admin/utils.py

    admin/views/__init__.py
    admin/views/dynamic_settings.py
    admin/views/flags.py
    admin/views/geoadmin.py
    admin/views/geomap.py
    admin/views/tanker.py

    admin/www_stations/__init__.py
    admin/www_stations/api.py
    admin/www_stations/convertors.py
    admin/www_stations/urls.py
)

PY_SRCS( TOP_LEVEL
    admins/__init__.py

    admins/common_apps/__init__.py
    admins/common_apps/facility_admins/__init__.py
    admins/common_apps/facility_admins/admin.py
    admins/common_apps/suburban_events_admins/__init__.py
    admins/common_apps/suburban_events_admins/admin.py
    admins/common_apps/train_admins/__init__.py
    admins/common_apps/train_admins/admin.py
    admins/common_apps/train_order_admins/__init__.py
    admins/common_apps/train_order_admins/admin.py

    api/__init__.py
    api/admin.py
    api/migrations/0001_initial.py
    api/migrations/__init__.py
    api/models.py

    configuration/__init__.py
    configuration/misc.py
    configuration/rsync.py

    configure_logs.py

    currency/__init__.py
    currency/admin.py
    currency/migrations/0001_initial.py
    currency/migrations/__init__.py
    currency/models.py

    cysix/__init__.py
    cysix/admin.py
    cysix/base.py
    cysix/fields.py
    cysix/filter_parameters.py

    cysix/filters/__init__.py
    cysix/filters/apply_base_stations.py
    cysix/filters/check_path_geometry.py
    cysix/filters/clear_consecutive_duplicate_rtstations.py
    cysix/filters/core/__init__.py
    cysix/filters/core/base.py
    cysix/filters/core/cysix_xml_thread.py
    cysix/filters/correct_arrival_time_by_map.py
    cysix/filters/correct_departure_and_arrival.py
    cysix/filters/correct_stop_time.py
    cysix/filters/cysix_xml_thread/__init__.py
    cysix/filters/cysix_xml_thread/skip_station_without_times.py
    cysix/filters/cysix_xml_validation.py
    cysix/filters/distance_calculator.py
    cysix/filters/fuzzy_flag_interpretation.py
    cysix/filters/import_geometry.py
    cysix/filters/set_default_flags.py
    cysix/filters/sort_stoppoints_by_supplier_distance.py
    cysix/filters/text_schedule_and_extrapolation.py
    cysix/filters/thread_comment.py
    cysix/filters/timezone_override.py

    cysix/forms.py

    cysix/migrations/0001_initial.py
    cysix/migrations/0002_add_geometry_check_filter.py
    cysix/migrations/0003_add_correct_arrival_time_by_map_filter.py
    cysix/migrations/0004_add_packagegroupfilter.py
    cysix/migrations/__init__.py

    cysix/models.py

    cysix/triangle/__init__.py
    cysix/triangle/triangle2cysix.py

    cysix/tsi_converter.py

    cysix/two_stage_import/__init__.py
    cysix/two_stage_import/data_provider.py
    cysix/two_stage_import/factory.py
    cysix/two_stage_import/importer.py
    cysix/two_stage_import/mask_parser.py
    cysix/two_stage_import/route_importer.py
    cysix/two_stage_import/schedule.py
    cysix/two_stage_import/utils.py
    cysix/two_stage_import/xml_thread.py

    cysix/utils/__init__.py
    cysix/utils/create_cysix_from_threads.py

    cysix/validation/__init__.py
    cysix/validation/urls.py
    cysix/validation/views.py
)

PY_SRCS(
    docker/local_settings.py

    gunicorn_conf.py
    gunicorn_conf_admin.py
    gunicorn_conf_service.py

    importinfo/__init__.py

    importinfo/admin/__init__.py
    importinfo/admin/e_traffic.py
    importinfo/admin/ipektur.py
    importinfo/admin/slices.py
    importinfo/admin/trusted_station.py

    importinfo/afdbchanges/__init__.py
    importinfo/afdbchanges/actions/__init__.py
    importinfo/afdbchanges/actions/default_store.py
    importinfo/afdbchanges/actions/www_settlement.py
    importinfo/afdbchanges/actions/www_station.py
    importinfo/afdbchanges/actions_store.py
    importinfo/afdbchanges/utils.py

    importinfo/blacklist.py
    importinfo/bus_stations.py
    importinfo/factories.py

    importinfo/management/__init__.py
    importinfo/management/commands/__init__.py
    importinfo/management/commands/run_tsi.py

    importinfo/migrations/0001_initial.py
    importinfo/migrations/0002_custom_indexes.py
    importinfo/migrations/0003_twostageimportpackage_t_subtype.py
    importinfo/migrations/0004_af_db_changes_file.py
    importinfo/migrations/0005_add_tsisetting_import_tariffs.py
    importinfo/migrations/0006_create_tsisetting_if_not_exists.py
    importinfo/migrations/0007_trusted_station.py
    importinfo/migrations/0008_twostageimportpackage_last_import_datetime.py
    importinfo/migrations/0009_add_train_turnover_files.py
    importinfo/migrations/0010_two_stage_import_new_trusted.py
    importinfo/migrations/0011_add_cysixgroupfilter_use_package_group_filters.py
    importinfo/migrations/__init__.py

    importinfo/models/__init__.py
    importinfo/models/af.py
    importinfo/models/bus.py
    importinfo/models/content_manager.py
    importinfo/models/e_traffic.py
    importinfo/models/express_2_country_cache.py
    importinfo/models/ipektur.py
    importinfo/models/mappings.py
    importinfo/models/model_extenders.py
    importinfo/models/tablo.py
    importinfo/models/trusted_station.py
    importinfo/models/two_stage_import.py
    importinfo/models/validators.py

    importinfo/related_log.py
    importinfo/triangle_import/__init__.py
    importinfo/triangle_import/mask_parser.py
    importinfo/turnovers.py

    importinfo/two_stage_import/__init__.py
    importinfo/two_stage_import/admin.py
    importinfo/two_stage_import/tariffs.py

    importinfo/utils/__init__.py
    importinfo/utils/thread.py

    lib/__init__.py
    lib/admin_options.py
    lib/adminutils.py
    lib/download_file.py
    lib/download_files.py
    lib/encoding.py
    lib/exceptions.py
    lib/fields.py
    lib/fileutils.py
    lib/geocoder.py
    lib/gtfs.py
    lib/http_timeout_handler.py
    lib/image.py
    lib/import_bounds.py
    lib/jinja.py
    lib/lock.py
    lib/logs.py
    lib/mail.py

    lib/maintenance/__init__.py
    lib/maintenance/db_update.py
    lib/maintenance/deploy.py
    lib/maintenance/flags.py
    lib/maintenance/scripts.py

    lib/maps/__init__.py
    lib/maps/client.py
    lib/maps/protobuf_models/__init__.py
    lib/maps/protobuf_models/yandex/__init__.py
    lib/maps/protobuf_models/yandex/maps/__init__.py
    lib/maps/protobuf_models/yandex/maps/proto/__init__.py
    lib/maps/protobuf_models/yandex/maps/proto/common2/__init__.py
    lib/maps/protobuf_models/yandex/maps/proto/common2/attribution_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/common2/geo_object_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/common2/geometry_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/common2/i18n_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/common2/keyvalue_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/common2/metadata_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/common2/response_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/common2/string_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/search/__init__.py
    lib/maps/protobuf_models/yandex/maps/proto/search/address_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/search/geocoder_internal_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/search/geocoder_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/search/kind_pb2.py
    lib/maps/protobuf_models/yandex/maps/proto/search/precision_pb2.py

    lib/mask_builder/__init__.py
    lib/mask_builder/afmask_builders.py
    lib/mask_builder/bounds.py
    lib/mask_builder/standard_builders.py
    lib/mask_builder/ycal_builders.py
    lib/mask_description.py

    lib/mda.py
    lib/metadata_conf.py
    lib/migrations.py
    lib/mysqlutils.py
    lib/osutils.py
    lib/parallelize.py
    lib/processes.py
    lib/redirect_email_backend.py
    lib/schedule.py
    lib/sql.py
    lib/text.py
    lib/tmpfiles.py
    lib/translation.py
    lib/types.py
    lib/un7zip.py
    lib/unittests/__init__.py
    lib/unittests/check_thread_mixin.py
    lib/unittests/server.py
    lib/unittests/testcase.py
    lib/unittests/utils.py
    lib/unpack_with_fallback.py
    lib/unrar.py
    lib/unzip.py
    lib/utils.py
    lib/xls.py
    lib/xmlutils.py
)

PY_SRCS( TOP_LEVEL
    managed_settings.py

    order/__init__.py
    order/admin.py

    order/migrations/0001_initial.py
    order/migrations/0002_partner_click_price_com.py
    order/migrations/0003_dohopvendor_review_percent.py
    order/migrations/0004_dohopvendor_dohop_id_index.py
    order/migrations/0005_add_dohopvendor_field_national_com_title.py
    order/migrations/0006_coachinfo_add_places.py
    order/migrations/0007_add_schema_details_svg_schema.py
    order/migrations/0008_add_coach_schema_ufs_code.py
    order/migrations/0009_place_price_rule_m2m_schema.py
    order/migrations/0010_coachinfo_ufs_code_rename.py
    order/migrations/0011_coachinfo_add_service_class.py
    order/migrations/0012_coach_info_binding_change.py
    order/migrations/0013_coach_info_binding_data.py
    order/migrations/0014_coach_info_partner_schema_code.py
    order/migrations/0015_coachinfobinding_klass_blank.py
    order/migrations/0016_fake_remove_old_fields_coachinfo.py
    order/migrations/0017_add_international_service_class.py
    order/migrations/0018_mds_img_storage.py
    order/migrations/0019_coachinfobinding_im_car_scheme_id.py
    order/migrations/__init__.py

    order/models.py
    order/settings.py
    order/utils.py

    patch_migration_writer.py

    promosearch/__init__.py
    promosearch/admin.py
    promosearch/migrations/0001_initial.py
    promosearch/migrations/__init__.py
    promosearch/models.py
)

PY_SRCS(
    scripts/autotranslate_stations.py
    scripts/build_namesearchindex.py
    scripts/build_pseudo_back_routes.py
    scripts/check_autoincrements.py
    scripts/check_base_integrity.py
    scripts/check_flag.py
    scripts/check_route_changes.py
    scripts/clean_empty_threads.py
    scripts/clean_old_dates.py
    scripts/clean_old_tariffs.py
    scripts/clean_or_fix_z_tables.py
    scripts/cron_daily_update.py
    scripts/cron_run.py
    scripts/cron_schedule.py
    scripts/cron_switch_bases.py
    scripts/cron_switch_copy_files.py
    scripts/db_name.py
    scripts/direction_bind.py

    scripts/export/export_bus_station_codes.py
    scripts/export/export_main_threads.py
    scripts/export/export_nearest_suburban.py
    scripts/export/export_stations_list.py
    scripts/export/export_suburban_cities.py
    scripts/export/export_suburban_informer.py
    scripts/export/export_suburban_stations.py
    scripts/export/gen_t_types_by_geoid_for_mobile_morda.py
    scripts/upload_to_s3.py

    scripts/fill_livemap.py
    scripts/fill_threads_canonical_uid.py
    scripts/fill_train_purchase_numbers.py
    scripts/finalize_deploy.py
    scripts/find_packages_to_reload_to_use_is_base.py
    scripts/gen_mask_description.py
    scripts/geobase_consistency_reports.py
    scripts/get_cache.py
    scripts/get_settings.py

    scripts/i18n/collect_platform_translations.py
    scripts/i18n/dbtanker.py
    scripts/i18n/fill_translates.py
    scripts/i18n/load_models.py

    scripts/import_middle_stations.py
    scripts/import_pseudo_gortrans.py
    scripts/invalidate_cache.py
    scripts/limepaths_check.py
    scripts/load_latest_db.py
    scripts/load_project.py
    scripts/make_fresh_dump.py
    scripts/moscow_quarantine_buses.py
    scripts/notify_bus_suppliers.py
    scripts/precalc_tariffs.py
    scripts/prepare_all.py
    scripts/rebuild_route_index.py
    scripts/refill_suggests.py
    scripts/refresh_partners_balance.py
    scripts/remove_obsolete_af_schedule.py
    scripts/rotate_temporary_data.py
    scripts/rsync.py

    scripts/schedule/af_processors/__init__.py
    scripts/schedule/af_processors/af_multiparam_mask_parser.py
    scripts/schedule/af_processors/af_thread_parser.py
    scripts/schedule/af_processors/common.py
    scripts/schedule/af_processors/parse_utils.py
    scripts/schedule/af_processors/suburban/__init__.py
    scripts/schedule/af_processors/suburban/affected_threads_finder.py
    scripts/schedule/af_processors/suburban/changemode_add.py
    scripts/schedule/af_processors/suburban/changemode_cancel.py
    scripts/schedule/af_processors/suburban/changemode_change.py
    scripts/schedule/af_processors/suburban/changemode_change_daystr.py
    scripts/schedule/af_processors/suburban/changemode_change_facilities.py
    scripts/schedule/af_processors/suburban/changemode_change_schedule_plan.py
    scripts/schedule/af_processors/suburban/changemode_change_weektemplate.py
    scripts/schedule/af_processors/suburban/changemode_delay.py
    scripts/schedule/af_processors/suburban/changemode_delete.py
    scripts/schedule/af_processors/suburban/changemode_insert.py
    scripts/schedule/af_processors/suburban/changemode_refill_calendar.py
    scripts/schedule/af_processors/suburban/changemode_replace.py
    scripts/schedule/af_processors/suburban/changemode_restore.py
    scripts/schedule/af_processors/suburban/changemode_rewrite_facilities.py
    scripts/schedule/af_processors/suburban/exceptions.py
    scripts/schedule/af_processors/suburban/utils/__init__.py
    scripts/schedule/af_processors/suburban/utils/facility.py
    scripts/schedule/af_processors/utils.py

    scripts/schedule/bus/allticketsfor_me.py
    scripts/schedule/bus/avokzal_kz.py
    scripts/schedule/bus/avperm.py
    scripts/schedule/bus/beltranscom.py
    scripts/schedule/bus/buscomua_cysix.py
    scripts/schedule/bus/dyc.py
    scripts/schedule/bus/e_traffic.py
    scripts/schedule/bus/import_mta.py
    scripts/schedule/bus/ipektur.py
    scripts/schedule/bus/kazan_bus.py
    scripts/schedule/bus/kmvavto.py
    scripts/schedule/bus/mrtrans.py
    scripts/schedule/bus/olven.py
    scripts/schedule/bus/tkvc.py
    scripts/schedule/bus/two_stage_autoimport.py
    scripts/schedule/bus/udmbuster.py
    scripts/schedule/bus/ukrmintrans.py

    scripts/schedule/check_suburban_mask_intersections.py
    scripts/schedule/get_rjd_routes.py
    scripts/schedule/import_af.py

    scripts/schedule/re_import.py
    scripts/schedule/re_import_af_schedule.py
    scripts/schedule/red_autoimport.py
    scripts/schedule/remove_old_slices.py

    scripts/schedule/tis_train/check_deluxe_trains.py
    scripts/schedule/tis_train/import_tis.py
    scripts/schedule/tis_train/importer.py
    scripts/schedule/tis_train/parser.py
    scripts/schedule/tis_train/utils.py

    scripts/schedule/tsi_update_station_flags.py
    scripts/schedule/update_af_suburban.py

    scripts/schedule/utils/__init__.py
    scripts/schedule/utils/afmasktext.py
    scripts/schedule/utils/clean_duplicates.py
    scripts/schedule/utils/code_sharing.py
    scripts/schedule/utils/errors.py
    scripts/schedule/utils/file_providers.py
    scripts/schedule/utils/ftp.py
    scripts/schedule/utils/mask_builders.py
    scripts/schedule/utils/olven.py
    scripts/schedule/utils/http_proxy.py
    scripts/schedule/utils/plane.py
    scripts/schedule/utils/report.py
    scripts/schedule/utils/route_compare.py
    scripts/schedule/utils/route_loader.py
    scripts/schedule/utils/schedule_validation.py
    scripts/schedule/utils/supplier_station.py
    scripts/schedule/utils/times_approximation.py
    scripts/schedule/utils/to_python_parsers.py
    scripts/schedule/utils/unicode_utf8_pprint.py

    scripts/set_flag.py
    scripts/settings.py
    scripts/settlement_coords.py
    scripts/settlement_view_types.py

    scripts/single/add_country_code3.py
    scripts/single/add_rzd_esr_codes.py
    scripts/single/add_rzd_esr_codes_data.py
    scripts/single/point_slugs_generator.py
    scripts/single/raspexport_171_replace_thread_title_dash.py
    scripts/single/raspfront_1825_fill_thread_tariff.py
    scripts/single/raspfront_4094_krim_express.py
    scripts/single/regenerate_import_uids.py

    scripts/sitemap/generate.py
    scripts/sitemap/sitemaps/city.py
    scripts/sitemap/sitemaps/external_direction.py
    scripts/sitemap/sitemaps/search.py
    scripts/sitemap/sitemaps/settlement_transport.py
    scripts/sitemap/sitemaps/station.py
    scripts/sitemap/sitemaps/thread.py
    scripts/sitemap/sitemaps/transport.py

    scripts/station_view_types.py
    scripts/suburban_events/calc_suburban_keys.py
    scripts/suburban_events/reimport_turnovers.py
    scripts/suburban_stops.py
    scripts/support_methods.py

    scripts/tariffs/import_suburban.py
    scripts/tariffs/update_blablacar_token.py
    scripts/tariffs_stats.py
    scripts/update_geobase.py
    scripts/update_queryblacklist.py
    scripts/update_reversed_numbers.py
    scripts/upload_static_to_s3.py

    scripts/utils/action_list.py
    scripts/utils/daily_update.py
    scripts/utils/delete_older_files.py
    scripts/utils/download_production_static.py
    scripts/utils/file_wrapper/mds_utils.py
    scripts/utils/file_wrapper/registry.py
    scripts/utils/file_wrapper/uploaders.py
    scripts/utils/import_file_storage.py
    scripts/utils/lock.py
    scripts/utils/to_python_parsers.py

    scripts/wizards/wizard_index.py
    scripts/wizards/wizard_queries.py
    scripts/wizards/wizard_queries_2.py
    scripts/wizards/wizard_stats.py
    scripts/wizards/wizard_words.py

    scripts/www_companies.py
    scripts/www_fill_country_title_of.py
    scripts/www_fill_preposition_in.py
    scripts/www_fix_station_types.py
    scripts/www_inflect_in_from_to.py
    scripts/www_rtstations.py
    scripts/www_settlements.py
    scripts/www_station_rise_majority.py
    scripts/www_stations.py

    scripts/z_noderoute2.py
    scripts/z_station_schedule.py
    scripts/z_station_schedule_test_schedule_length.py
)

PY_SRCS( TOP_LEVEL
    settings.py
    tests_settings.py
    static/rasp/geoadmins/__init__.py

    staticpages/__init__.py
    staticpages/admin.py
    staticpages/migrations/0001_initial.py
    staticpages/migrations/0002_partner_dohop_vendor.py
    staticpages/migrations/0003_staticpages_articlebinding.py
    staticpages/migrations/0004_mds_img_storage.py
    staticpages/migrations/__init__.py
    staticpages/models.py

    stats/__init__.py
    stats/admin.py
    stats/migrations/0001_initial.py
    stats/migrations/__init__.py
    stats/models.py
    stats/urls.py
    stats/views.py

    suburban_change_notices/__init__.py
    suburban_change_notices/admin.py
    suburban_change_notices/management/__init__.py
    suburban_change_notices/management/commands/__init__.py
    suburban_change_notices/management/commands/send_suburban_notifications.py
    suburban_change_notices/migrations/0001_initial.py
    suburban_change_notices/migrations/__init__.py
    suburban_change_notices/models.py
    suburban_change_notices/sending.py
    suburban_change_notices/settings.py

    tariffs_admin/__init__.py
    tariffs_admin/admin.py
    tariffs_admin/migrations/0001_initial.py
    tariffs_admin/migrations/0002_delete_ufs_days_ahead.py
    tariffs_admin/migrations/0003_delete_old_ufs_tables.py
    tariffs_admin/migrations/__init__.py
    tariffs_admin/models.py

    templates/__init__.py
    templates/bemhtml/__init__.py
    templates/bemhtml/validate.py
)

PY_SRCS(
    mds_files_viewer/urls.py
    mds_files_viewer/views.py
)

PY_SRCS(
    timecorrection/__init__.py
    timecorrection/admin.py
    timecorrection/admin_functions.py
    timecorrection/compare_and_processing.py
    timecorrection/correction.py
    timecorrection/data_downloaders.py
    timecorrection/duration_processing.py
    timecorrection/migrations/0001_initial.py
    timecorrection/migrations/0002_sql_cascade.py
    timecorrection/migrations/0003_correction_result.py
    timecorrection/migrations/0004_sql_cascade_for_correction_result.py
    timecorrection/migrations/0005_permanent_path_data.py
    timecorrection/migrations/__init__.py
    timecorrection/models.py
    timecorrection/models_data_access.py
    timecorrection/path_checkers.py
    timecorrection/scripts/__init__.py
    timecorrection/scripts/init_pathtime.py
    timecorrection/scripts/init_temp_rthread.py
    timecorrection/urls.py
    timecorrection/utils/__init__.py
    timecorrection/utils/_math.py
    timecorrection/view.py
)

PY_SRCS( TOP_LEVEL
    urls.py
)

PY_SRCS(
    wsgi.py

    www/__init__.py
    www/admin.py
    www/context.py
    www/db/__init__.py

    www/management/__init__.py
    www/management/commands/__init__.py
    www/management/commands/maketestdb.py
    www/management/commands/remove_flag.py
    www/management/commands/update.py
    www/management/commands/update_date_validator_js.py
    www/management/commands/update_i_time_translations.py

    www/middleware.py

    www/migrations/0001_initial.py
    www/migrations/0002_refs_to_other_submodules_and_custom_fields.py
    www/migrations/0003_agent_part_length.py
    www/migrations/0004_threadtariff_new_fields.py
    www/migrations/0005_fill_thread_tariffs.py
    www/migrations/0006_threadtariff_index_for_search.py
    www/migrations/0007_tariff_groups.py
    www/migrations/0008_deluxetrain_fields.py
    www/migrations/0009_deluxetrain_numbers.py
    www/migrations/0010_change_field_deluxe_train.py
    www/migrations/0011_aeroextariff_update_index.py
    www/migrations/0012_fix_default_for_t_type_relation.py
    www/migrations/0013_change_thread_title_length.py
    www/migrations/0014_tariffgroup_localization.py
    www/migrations/0015_namesearchindex_index.py
    www/migrations/0016_company_permission_other_small_changes.py
    www/migrations/0017_remove_old_fileds.py
    www/migrations/0018_remove_old_fileds_and_tables.py
    www/migrations/0019_add_tarifftype_description.py
    www/migrations/0020_tarifftype_description_ru_may_be_empty.py
    www/migrations/0021_auto_20170118_1507.py
    www/migrations/0022_company_tis_code.py
    www/migrations/0023_delete_not_usedd_tables.py
    www/migrations/0024_add_teasers_uids.py
    www/migrations/0025_add_teasers_64bit_uids.py
    www/migrations/0026_add_country_code3.py
    www/migrations/0027_add_suburban_forecast_flags.py
    www/migrations/0028_change_suburban_forecast_flag.py
    www/migrations/0029_transport-new-plane-fields.py
    www/migrations/0030_station_is_base_modified_at.py
    www/migrations/0031_add_settlement_use_in_suburban_app_suggests_field.py
    www/migrations/0032_transport_subtype_add_title_short.py
    www/migrations/0033_add_train_turnover.py
    www/migrations/0034_add_company_marker.py
    www/migrations/0035_add_page_path.py
    www/migrations/0036_add_slugs.py
    www/migrations/0037_slugs_to_lower_case.py
    www/migrations/0038_znoderoute2_add_t_type.py
    www/migrations/0039_add_displace_yabus.py
    www/migrations/0040_add_transportsubtype_has_train_tariffs.py
    www/migrations/0041_create_trainpurchasenumber.py
    www/migrations/0042_add_express_code_to_company_model.py
    www/migrations/0043_z_noderoute2_add_good_for_start_finish.py
    www/migrations/0044_company_add_yandex_avia_code.py
    www/migrations/0045_add_deluxe_t_subtype.py
    www/migrations/0046_thread_canonical_uid.py
    www/migrations/0047_canonical_uid_index.py
    www/migrations/0048_create_platform_presentation.py
    www/migrations/0049_add_trainturnover_number_xxx.py
    www/migrations/0050_remove_trainturnover_number_xxx.py
    www/migrations/0051_multiple_tariffs_in_suburban_segment.py
    www/migrations/0052_way_to_airport.py
    www/migrations/0053_way_to_airport_and_agreed_stops.py
    www/migrations/0054_agreed_stops.py
    www/migrations/0055_remove_holidays_and_way_to_airport_fields.py
    www/migrations/0056_add_train_number_to_rtstation.py
    www/migrations/0057_pathfinder_maps_nearest_settlement.py
    www/migrations/0058_pointsynonym_language.py
    www/migrations/0059_mds_img_storage.py
    www/migrations/0060_t_subtype_use_in_suburban_search.py
    www/migrations/0061_t_subtype_suburban_title.py
    www/migrations/0062_deluxe_train_check_fields.py
    www/migrations/0063_deluxe_train_check_min_im_records_count.py
    www/migrations/__init__.py

    www/models/__init__.py
    www/models/geo.py
    www/models/precalc.py
    www/models/schedule.py
    www/models/suggests.py
    www/models/tariffs.py

    www/templatetags/__init__.py
    www/templatetags/common.py
    www/templatetags/durations.py
    www/templatetags/html.py
    www/templatetags/quick_tree_add_obj.py
    www/templatetags/quick_tree_nav.py

    www/utils/__init__.py
    www/utils/calendar_templates.py
    www/utils/common.py
    www/utils/data.py
    www/utils/district_import.py
    www/utils/language.py
    www/utils/mysql.py
    www/utils/uids.py

    www/views/__init__.py
)

PY_SRCS( TOP_LEVEL
    www_admin/__init__.py
    www_admin/models/__init__.py
    www_admin/models/geo.py
    www_admin/models/route_search.py
    www_admin/models/schedule.py
    www_admin/models/stationschedule.py
    www_admin/models/tariffs.py

    www_extra/__init__.py
    www_extra/admin.py
    www_extra/migrations/0001_initial.py
    www_extra/migrations/__init__.py
    www_extra/models.py
)

RESOURCE_FILES( PREFIX travel/rasp/admin/
    admin/locale/be/LC_MESSAGES/django.mo
    admin/locale/en/LC_MESSAGES/django.mo
    admin/locale/kk/LC_MESSAGES/django.mo
    admin/locale/ru/LC_MESSAGES/django.mo
    admin/locale/tt/LC_MESSAGES/django.mo
    admin/locale/uk/LC_MESSAGES/django.mo
)

END()

RECURSE(
    bin
    tests_integration
    markup_package
)

RECURSE_FOR_TESTS(
    bin/tests
)

