import argparse

import coloredlogs

import travel.rasp.analytics.blablacar_report.lib.report as report


def parse_args():
    parser = argparse.ArgumentParser(description='Generate and send blablacar report')
    parser.add_argument(
        '--to-emails',
        dest='to_emails',
        default='mangin@yandex.team.ru,corroder@yandex-team.ru',
        required=True,
        help='to emails (default: maintainer\'s list)',
    )
    parser.add_argument(
        '--cc-emails',
        dest='cc_emails',
        default='',
        required=False,
        help='cc emails (default: empty list)',
    )
    parser.add_argument(
        '--click-user',
        dest='click_user',
        default='corroder',
        required=True,
        help='metric\'s click house user (default: corroder)',
    )
    parser.add_argument(
        '--click-pass',
        dest='click_pass',
        default='broken_password',
        required=True,
        help='metric\'s click house password (default: broken_password)',
    )
    parser.add_argument(
        '--click-host',
        dest='click_host',
        default='http://clickhouse.metrika.yandex.net:8123/',
        required=False,
        help='metric\'s click house host (default: http://clickhouse.metrika.yandex.net:8123/)',
    )
    parser.add_argument(
        '--output',
        dest='output',
        default='/tmp/report.xlsx',
        required=False,
        help='future repot\'s file location',
    )

    return parser.parse_args()


if __name__ == '__main__':
    coloredlogs.install(level='INFO', fmt='%(message)s')
    args = parse_args()

    to_emails = args.to_emails.split(',')
    cc_emails = args.cc_emails.split(',')
    click_user = args.click_user
    click_pass = args.click_pass
    click_host = args.click_host

    report.do_report_send('/tmp/report.xlsx', to_emails, cc_emails, click_user, click_pass, click_host)
