# -*- coding: utf-8 -*-

from functools import wraps

from common.xgettext.i18n import gettext

from . import points
from .api_errors import ApiError


class ApiContext(object):
    show_systems = None


def add_api_context(view_func):
    @wraps(view_func)
    def wrapper(request, *args, **kwargs):
        api_context = request.external_api_context = ApiContext()

        show_systems = request.GET.get('show_systems', u'').strip()
        show_systems = [s for s in map(unicode.strip, show_systems.split(u',')) if s]
        if 'all' in show_systems:
            api_context.show_systems = points.ALLOWED_SYSTEMS
        else:
            not_supported_systems = set(show_systems) - set(points.ALLOWED_SYSTEMS)
            if not_supported_systems:
                raise ApiError(
                    gettext(u'Не поддерживаемые системы кодирования {}').format(
                        u', '.join(not_supported_systems)
                    ), http_code=400
                )

            api_context.show_systems = show_systems

        return view_func(request, *args, **kwargs)

    return wrapper
