# -*- coding: utf-8 -*-

import logging
from urllib2 import urlopen
from urlparse import urljoin

import requests
from django.conf import settings
from django.http import Http404
from django.utils.http import urlencode
from raven.contrib.django.raven_compat.models import client

from common.xgettext.i18n import gettext
from common.utils.threadutils import run_in_thread

from .api_errors import ApiError

CHECK_KEY_TIMEOUT = 0.3
log = logging.getLogger(__name__)


def update_counter(request, hits=None, bytes=None):
    if settings.APIKEYS_ENABLED:
        run_in_thread(_update_counter, args=(request,), kwargs={'hits': hits, 'bytes': bytes})


def _update_counter(request, hits=None, bytes=None):
    key = request.GET.get('apikey', u'').strip()

    if not key:
        log.error(u'Не указан ключ')
        return

    params = {
        'key': key,
        'service_token': settings.APIKEYS_SERVICE_TOKEN,
    }

    if hits is not None:
        params['hits'] = hits

    if bytes is not None:
        params['bytes'] = bytes

    url = urljoin(settings.APIKEYS_URL, 'update_counters') + '?' + urlencode(params)

    log.debug(u'Обновляем счетчики %s', url)

    try:
        urlopen(url, timeout=30).read()
    except Exception:
        log.exception(u'Ошибка обновления счетчика')


def check_key(request):
    key = request.GET.get('apikey', u'').strip()
    if not settings.APIKEYS_ENABLED:
        return True

    if not key:
        raise ApiError(gettext(u'Не указан ключ'), http_code=400)

    params = {
        'user_ip': request.META.get('REMOTE_ADDR', ''),
        'key': key,
        'service_token': settings.APIKEYS_SERVICE_TOKEN
    }

    url = urljoin(settings.APIKEYS_URL, 'check_key') + '?' + urlencode(params)

    log.debug(u'Проверяем ключ %s', url)

    def raise_invalid_key_error():
        log.warning(u'Неверный ключ %s %s %s', key, getattr(resp, 'code', None), getattr(resp, 'msg', None))
        raise ApiError(gettext(u'Неверный ключ "{}"').format(key), http_code=400)

    try:
        resp = requests.get(url, timeout=CHECK_KEY_TIMEOUT)

        if resp.status_code == 404:
            raise Http404

        result = resp.json()

        if result.get('result') == 'OK':
            return True

    except Http404:
        raise_invalid_key_error()

    except Exception as ex:
        log.warning(u'Сервис ключей не ответил. Ошибка - %s. Используемый ключ - %s', repr(ex), key)
        client.captureException()
        return True

    else:
        raise_invalid_key_error()
