# -*- coding: utf-8 -*-
from __future__ import absolute_import

from functools import wraps

from travel.rasp.api_public.api_public.old_versions.core.api_response import api_response
from travel.rasp.api_public.api_public.old_versions.core.api_context import add_api_context
from travel.rasp.api_public.api_public.old_versions.core.api_errors import ApiError
from django.conf import settings


def api_view(view_func):
    @wraps(view_func)
    @api_response
    @add_api_context
    def wrapper(request, *args, **kwargs):
        return view_func(request, *args, **kwargs)

    return wrapper


def api_view_method(call_method):
    @wraps(call_method)
    def wrapper(self, request, *args, **kwargs):
        @api_response
        @add_api_context
        def _mediator(_request, *_args, **_kwargs):
            return call_method(self, _request, *_args, **_kwargs)

        return _mediator(request, *args, **kwargs)

    return wrapper


def check_country(request):
    try:
        country_code = request.GET['country']
    except KeyError:
        raise ApiError(u'A country code is not specified.', http_code=400)

    country_code = country_code.upper()
    try:
        request.tld = settings.COUNTRY_ISO_TO_TLD[country_code]
    except KeyError:
        raise ApiError(u'The country code {} is not supported.'.format(country_code), http_code=400)

    try:
        request.NATIONAL_VERSION = settings.COUNTRY_ISO_TO_NATIONAL_VERSION[country_code]
    except KeyError:
        request.NATIONAL_VERSION = settings.COUNTRY_ISO_TO_NATIONAL_VERSION['RU']


def country_required(view_handler):
    @wraps(view_handler)
    def func_wrapper(request, *args, **kwargs):
        check_country(request)
        return view_handler(request, *args, **kwargs)

    return func_wrapper


def country_required_method(view_handler):
    @wraps(view_handler)
    def method_wrapper(self, *args, **kwargs):
        check_country(self.request)
        return view_handler(self, *args, **kwargs)

    return method_wrapper
