# -*- coding: utf-8 -*-

from django.http import HttpResponse
from django.conf import settings

from common.xgettext.i18n import gettext
from ..api_response import api_response
from ..api_errors import ApiError
from ..decorators import api_view


@api_response
def no_such_url(request):
    raise ApiError(
        gettext(u'Неправильный запрос {path}. Пожалуйста проверьте версию и путь запроса').format(
            path=request.path
        ), http_code=400
    )


def version(request):
    return HttpResponse(
        '%s\n\n%s' % (settings.PKG_VERSION, settings.SUBMODULE_STATUS),
        content_type="text/plain"
    )


@api_view
def copyright_view(request):
    static_url = '//yandex.st/rasp/media'
    return {
        'copyright': {
            'text': gettext(u'Данные предоставлены сервисом Яндекс.Расписания'),
            'url': 'http://rasp.yandex.ru/',
            'logo_vy': '<iframe frameborder="0"'
                       ' style="overflow: hidden; border: 0; width: 240px; height: 130px;"'
                       ' src="{}/apicc/copyright_vert_yellow.html"></iframe>'
                       .format(static_url),

            'logo_vm': '<iframe frameborder="0"'
                       ' style="overflow: hidden; border: 0; width: 240px; height: 130px;"'
                       ' src="{}/apicc/copyright_vert_mono.html"></iframe>'
                       .format(static_url),

            'logo_vd': '<iframe frameborder="0"'
                       ' style="overflow: hidden; border: 0; width: 240px; height: 130px;"'
                       ' src="{}/apicc/copyright_vert_dark.html"></iframe>'
                       .format(static_url),

            'logo_hy': '<iframe frameborder="0"'
                       ' style="overflow: hidden; border: 0; width: 740px; height: 51px;"'
                       ' src="{}/apicc/copyright_horiz_yellow.html"></iframe>'
                       .format(static_url),

            'logo_hm': '<iframe frameborder="0"'
                       ' style="overflow: hidden; border: 0; width: 740px; height: 51px;"'
                       ' src="{}/apicc/copyright_horiz_mono.html"></iframe>'
                       .format(static_url),

            'logo_hd': '<iframe frameborder="0"'
                       ' style="overflow: hidden; border: 0; width: 740px; height: 51px;"'
                       ' src="{}/apicc/copyright_horiz_dark.html"></iframe>'
                       .format(static_url),
        }
    }
