# -*- coding: utf-8 -*-

from common.models.schedule import Company
from common.xgettext.i18n import gettext

from ..api_errors import ApiError


def get_carriers(request):
    system = request.GET.get('system', u'yandex')
    carrier_code = request.GET.get('code', u'').strip()

    carriers = []

    if system == 'yandex':
        try:
            carrier_code = int(carrier_code)
            carriers = [Company.hidden_manager.get(id=carrier_code)]
        except (Company.DoesNotExist, ValueError):
            pass

    elif system == 'iata':
        carriers = list(Company.hidden_manager.filter(iata=carrier_code))

    elif system == 'icao':
        try:
            carriers = [Company.hidden_manager.get(icao=carrier_code)]
        except Company.DoesNotExist:
            pass

    elif system == 'sirena':
        try:
            carriers = [Company.hidden_manager.get(sirena_id=carrier_code)]
        except Company.DoesNotExist:
            pass

    else:
        raise ApiError(text=gettext(u'Система кодирования {system} не используется').format(
            system=system
        ), http_code=400)

    if not carriers:
        raise ApiError(gettext(u'Не нашли компании по коду {system}="{code}"').format(
            system=system, code=carrier_code
        ), http_code=404)

    carriers.sort(key=lambda c: (c.priority, c.id))

    return carriers
