# -*- coding: utf-8 -*-

from datetime import datetime

from travel.rasp.api_public.api_public.old_versions.core.helpers import check_date_range
from common.models.schedule import RThread
from common.models_utils.i18n import RouteLTitle
from common.xgettext.i18n import gettext
from travel.rasp.library.python.common23.date import environment

from ..api_errors import ApiError


def get_thread(thread_uid, departure_date):
    try:
        thread = RThread.objects.exclude(
            route__supplier__exclude_from_external_api=True).get(uid=thread_uid)
    except RThread.DoesNotExist:
        raise ApiError(gettext(u'Рейса с uid {} нет в базе').format(thread_uid), http_code=404)

    today = environment.today()
    path = list(thread.display_path)

    if not path:
        raise ApiError(gettext(u'Рейса с uid {} нет в базе').format(thread_uid), http_code=404)

    first_rtstation = path[0]

    RouteLTitle.fetch([thread.L_title])

    first_run_d = thread.first_run(today)
    if not first_run_d:
        raise ApiError(gettext(u'Рейса с uid {} нет в базе').format(thread_uid),
                       http_code=404)

    naive_start_dt = None
    if departure_date:
        try:
            departure_date = datetime.strptime(departure_date, '%Y-%m-%d').date()
        except ValueError:
            raise ApiError(gettext(u'Дата должна быть в формате YYYY-MM-DD'), http_code=400)

        check_date_range(departure_date)

        start_date = first_rtstation.calc_thread_start_date(event='departure', event_date=departure_date)

        naive_start_dt = datetime.combine(start_date, thread.tz_start_time)

        if not thread.runs_at(naive_start_dt):
            raise ApiError(gettext(u'Рейс {} не ходит {}').format(thread_uid, departure_date),
                           http_code=404)

    if not naive_start_dt:
        naive_start_dt = datetime.combine(first_run_d, thread.tz_start_time)

    return thread, path, naive_start_dt
