# -*- coding: utf-8 -*-

from travel.rasp.api_public.api_public.old_versions.core.decorators import api_view
from travel.rasp.api_public.api_public.old_versions.core.helpers import get_code_getter, ApiPaginateView, SegmentsSearcher
from travel.rasp.api_public.api_public.old_versions.core.views.station_schedule import ScheduleView
from travel.rasp.api_public.api_public.old_versions.core.views.carrier import get_carriers
from travel.rasp.api_public.api_public.old_versions.core.views.thread import get_thread
from travel.rasp.api_public.api_public.old_versions.core.views.nearest import NearestStationsView
from travel.rasp.api_public.api_public.old_versions.core.train_schedule import set_train_schedule_plan
from travel.rasp.api_public.api_public.old_versions.v1 import json_helpers
from common.models.schedule import TrainSchedulePlan, RTStation
from common.models_utils import fetch_related
from travel.rasp.library.python.common23.date import environment


class SearchView(ApiPaginateView):

    def handle(self, *args, **kwargs):
        searcher = SegmentsSearcher(self.request)

        segments = searcher.search()
        set_train_schedule_plan(segments)

        query = searcher.query

        code_getter = get_code_getter(self.request, (query.point_from, query.point_to))

        pagination_json, segments = self.paginate(segments)

        transport_subtype = self.request.GET.get('transport_subtype', False) == 'true'

        fetch_related([segment.rtstation_from for segment in segments], 'station', 'thread', model=RTStation)

        return {
            'pagination': pagination_json,
            'search': {
                'from': json_helpers.point2json(query.point_from, code_getter),
                'to': json_helpers.point2json(query.point_to, code_getter),
                'date': query.date,
            },
            'threads': json_helpers.segments2json(segments, query, transport_subtype)
        }


@api_view
def thread_info(request):
    thread_uid = request.GET.get('uid', u'').strip()
    departure_date = request.GET.get('date', u'').strip()

    transport_subtype = request.GET.get('transport_subtype', False) == 'true'

    thread, path, naive_start_dt = get_thread(thread_uid, departure_date)
    current_plan, next_plan = TrainSchedulePlan.add_to_threads([thread], environment.today())

    return json_helpers.threadinfo2json(request, thread, path, naive_start_dt, next_plan=next_plan,
                                        transport_subtype=transport_subtype)


@api_view
def carrier(request):
    carriers = get_carriers(request)

    carriers = map(lambda c: json_helpers.Company2Json()(c, verbose=True), carriers)

    if len(carriers) == 1:
        return {
            'carrier': carriers[0]
        }

    return {
        'carriers': carriers
    }


search_view = SearchView()

station_schedule_view = ScheduleView()

nearest_stations = NearestStationsView()
