# -*- coding: utf-8 -*-

import math

from route_search.shortcuts import find_on_all_days

from common.models.transport import TransportType
from common.xgettext.i18n import gettext

from travel.rasp.api_public.api_public.old_versions.core import points
from travel.rasp.api_public.api_public.old_versions.core.api_errors import ApiError
from travel.rasp.api_public.api_public.old_versions.core.decorators import api_view


@api_view
def routes_info(request):
    system = request.GET.get('system', u'yandex')
    code_from = request.GET.get('from', u'').strip()
    code_to = request.GET.get('to', u'').strip()

    if not (code_from and code_to):
        raise ApiError(gettext(u'Нужно указать from и to.'), http_code=400)

    point_from = points.PointFinder.find_point(system, code_from)
    point_to = points.PointFinder.find_point(system, code_to)

    if point_to == point_from:
        raise ApiError(gettext(u'Нужно указать разные аэропорты отправления и прибытия.'), http_code=400)

    segments = find_on_all_days(point_from, point_to, TransportType.objects.get(id=TransportType.PLANE_ID))
    segments_count = len({segment.number for segment in segments})
    min_duration = int(math.ceil(float(min([segment.duration for segment in segments]).seconds) / 60)) if segments else 0

    return {
        'min_duration': min_duration,
        'routes_count': segments_count
    }
