# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.conf.urls import include, url
from django.conf.urls.static import static

from common.views.db_info import db_info

from travel.rasp.api_public.api_public.old_versions.core.views import no_such_url, version


urlpatterns = [
    url(r'^v3/', include('travel.rasp.api_public.api_public.v3.urls')),
    url(r'^v3\.0/', include('travel.rasp.api_public.api_public.v3.urls')),
    url(r'^v3\.0\.0/', include('travel.rasp.api_public.api_public.v3.urls')),

    url(r'^v2/', include('travel.rasp.api_public.api_public.old_versions.v2.urls')),
    url(r'^v2\.0/', include('travel.rasp.api_public.api_public.old_versions.v2.urls')),
    url(r'^v2\.0\.0/', include('travel.rasp.api_public.api_public.old_versions.v2.urls')),

    url(r'^v1/', include('travel.rasp.api_public.api_public.old_versions.v1.urls')),
    url(r'^v1\.0/', include('travel.rasp.api_public.api_public.old_versions.v1.urls')),
    url(r'^v1\.0\.0/', include('travel.rasp.api_public.api_public.old_versions.v1.urls')),

    url(r'^version$', version),

    url(r'^dev/dbinfo$', db_info),

    url(r'^.*', no_such_url),
]

if settings.DEBUG:
    import debug_toolbar

    urlpatterns = ([url(r'^__debug__/', include(debug_toolbar.urls))] +
                   static(settings.STATIC_URL, document_root=settings.STATIC_ROOT) +
                   urlpatterns)
