# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import inspect

from common.utils.exceptions import SimpleUnicodeException


class ApiError(SimpleUnicodeException):
    """
    Ошибка использования API, клиентом.
    """

    def __init__(self, text, http_code=200):
        self.text = text
        self.http_code = http_code

        stack = inspect.stack()
        caller_frame_record = stack[1]
        line_no = caller_frame_record[2]

        self.error_code = line_no

        msg = u'ApiError: {} {} {}'.format(
            self.error_code, self.http_code, self.text
        )

        super(ApiError, self).__init__(msg)


class ApiInternalError(SimpleUnicodeException):
    """
    Ошибка программирования API, возникает по нашей вине. При неправильном использовании внутренних
    инструментов.
    """
