# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from urllib2 import urlopen
from urlparse import urljoin

import requests
from django.conf import settings
from django.utils.http import urlencode

from common.xgettext.i18n import gettext
from common.utils.threadutils import run_in_thread

from .api_errors import ApiError


CHECK_KEY_TIMEOUT = 0.3
log = logging.getLogger(__name__)


def update_counter(request, hits=None, bytes=None):
    if settings.APIKEYS_ENABLED:
        run_in_thread(_update_counter, args=(request,), kwargs={'hits': hits, 'bytes': bytes})


def _update_counter(request, hits=None, bytes=None):
    key = request.GET.get('apikey', u'').strip()

    if not key:
        log.error(u'Не указан ключ')
        return

    params = {
        'key': key,
        'service_token': settings.APIKEYS_SERVICE_TOKEN,
    }

    if hits is not None:
        params['hits'] = hits

    if bytes is not None:
        params['bytes'] = bytes

    url = urljoin(settings.APIKEYS_URL, 'update_counters') + '?' + urlencode(params)

    log.debug(u'Обновляем счетчики %s', url)

    try:
        urlopen(url, timeout=3).read()
    except Exception:
        log.exception(u'Ошибка обновления счетчика')


def get_key(request):
    return request.GET.get('apikey', u'').strip() or request.META.get('HTTP_AUTHORIZATION', u'').strip()


def check_key(request):
    if not settings.APIKEYS_ENABLED:
        return True

    key = get_key(request)

    if not key:
        raise ApiError(gettext(u'Не указан ключ'), http_code=400)

    params = {
        'user_ip': request.META.get('REMOTE_ADDR', ''),
        'key': key,
        'service_token': settings.APIKEYS_SERVICE_TOKEN
    }

    url = urljoin(settings.APIKEYS_URL, 'check_key') + '?' + urlencode(params)

    log.debug(u'Проверяем ключ %s', url)

    try:
        resp = requests.get(url, timeout=CHECK_KEY_TIMEOUT)
        result = resp.json()

        if resp.status_code == 200 and result.get('result') == 'OK':
            return True

        if resp.status_code == 404 and result.get('error', '') .lower() == 'service not found':
            log.error(u'Сервис не найден. Ошибка - %s. Используемый ключ - %s', result['error'], key)
            return True

    except Exception as ex:
        log.error(u'Произошла ошибка во время запроса к сервису ключей. Ошибка - %s. Используемый ключ - %s', repr(ex), key)
        return True
    else:
        if resp.status_code == 403 and result.get('error', '').lower() == 'key is not active':
            log.error(u'Ключ не активен: %s, %s', result['error'], key)
            raise ApiError(gettext(u'Ключ не активен "{}"').format(key), http_code=429)

        log.warning(u'Неверный ключ %s %s %s', key, getattr(resp, 'code', None), getattr(resp, 'msg', None))
        raise ApiError(gettext(u'Неверный ключ "{}"').format(key), http_code=400)
