# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import datetime, date, timedelta, time

from django.conf import settings

from common.models.currency import Currency
from common.views.currency import CurrencyInfo

from travel.rasp.api_public.api_public.v3.core import points


def get_code_getter(points_to_collect, show_systems):
    code_getter = points.CodeGetter(show_systems)
    map(code_getter.collect_point, points_to_collect)
    code_getter.fetch_codes()
    return code_getter


def get_currency_info(tld, currency=None):
    geo_id = settings.TLD_TO_GEO_ID[tld]
    currencies = list(Currency.objects.all())
    src, rates = Currency.fetch_rates(currencies, geo_id)

    # Оставляем только валюты с курсом и названием
    available = {
        currency.code
        for currency in currencies
        if (currency.L_name() and currency.L_name_in() and currency.code in rates)
    }

    set_preferred = False
    if currency in available:
        selected = currency
        set_preferred = True
    else:
        selected = settings.DOMAIN_CURRENCY.get(tld)

    # Если все обломалось, используем рубли
    if not selected or selected not in available:
        selected = Currency.BASE_CURRENCY

    country_base = CurrencyInfo.country_base_from_tld(tld)
    return CurrencyInfo(
        selected,
        set_preferred,
        country_base,
        src,
        rates,
        available,
        currencies
    )


def get_search_points(system_from, system_to, code_from, code_to):
    point_from = points.PointFinder.find_point(system_from, code_from)
    point_to = points.PointFinder.find_point(system_to, code_to)
    return point_from, point_to


def find_rtstation(point, rtstations):
    for rts in rtstations:
        if point in (rts.station, getattr(rts.station, 'settlement', None)):
            return rts


def dt_to_tz_date(dt, tz):
    if not dt:
        return None
    if dt.tzinfo:
        return dt.astimezone(tz).date()
    return tz.localize(dt).date()


def serialize_date_time(obj):
    if isinstance(obj, datetime):
        return obj.strftime("%Y-%m-%d %H:%M:%S")

    if isinstance(obj, date):
        return obj.strftime("%Y-%m-%d")

    if isinstance(obj, timedelta):
        return obj.seconds + obj.days * 84600

    if isinstance(obj, time):
        return obj.strftime('%H:%M')
