# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db.models import Q

from common.models.geo import Station
from common.utils import geo

from travel.rasp.api_public.api_public.geobase_helpers import calc_points_distance_km


def nearest_stations(lat, lng, distance, station_types, transport_types):
    """
    Неправильно работает, если longitude близка к 0 или 360
    """
    center_point = Station(latitude=lat, longitude=lng)

    # Берем квадрат такой чтобы вписать туда круг с радиусом distance
    (lat_top, lon_left), (lat_bottom, lon_right) = \
        geo.get_square_around_point(center_point, distance * 2)

    coords_filter = (
        Q(latitude__isnull=False, longitude__isnull=False) &
        Q(latitude__gte=lat_top, latitude__lte=lat_bottom) &
        Q(longitude__gte=lon_left, longitude__lte=lon_right)
    )

    station_qs = Station.hidden_manager.filter(coords_filter).order_by()
    if transport_types:
        station_qs = station_qs.filter(t_type__in=transport_types)

    if station_types:
        station_qs = station_qs.filter(station_type__in=station_types)

    stations = list(station_qs)

    for s in stations:
        s.distance = calc_points_distance_km(center_point, s)

    stations.sort(key=lambda _s: (_s.distance, _s.majority_id))

    return [s for s in stations if s.distance <= distance]
