# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.utils.encoding import smart_text
from django.utils import six
from inflect import engine
from rest_framework.negotiation import BaseContentNegotiation
from rest_framework_xml.renderers import XMLRenderer

from travel.rasp.api_public.api_public.v3.core.api_response import serialize_date_time


class IgnoreClientContentNegotiation(BaseContentNegotiation):
    URLS_WITHOUT_RENDER = [
        '/v3.0/stations_list/'
    ]

    def select_renderer(self, request, renders, *args):
        renders_dict = settings.RENDERS_DICT
        accepts_types = settings.ACCEPT_TYPES

        debug = request.GET.get('debug', None)
        if debug:
            return renders[renders_dict['debug']], renders[renders_dict['debug']].media_type

        out_format = request.GET.get('format', None)

        accept_header = request.META.get('HTTP_ACCEPT')
        if not out_format and accept_header:
            formats = accept_header.split(',')
            for resp_format in formats:
                out_format = accepts_types.get(resp_format)
                if out_format:
                    break

        if any(request.path == url for url in self.URLS_WITHOUT_RENDER):
            if not out_format:
                out_format = 'json'
            return renders[renders_dict['html']], renders[renders_dict[out_format]].media_type

        if out_format == 'xml':
            return renders[renders_dict['xml']], renders[renders_dict['xml']].media_type

        if out_format == 'json':
            if request.GET.get('callback', None):
                return renders[renders_dict['html']], renders[renders_dict['html']].media_type
            return renders[renders_dict['json']], renders[renders_dict['json']].media_type

        return renders[renders_dict['json']], renders[renders_dict['json']].media_type


class ApiXMLRender(XMLRenderer):
    root_tag_name = u'response'
    inflect_engine = engine()

    def _to_xml(self, xml, data, key=None):
        if isinstance(data, (list, tuple)):
            item_tag = self.inflect_engine.singular_noun(key) or key
            for item in data:
                xml.startElement(item_tag, {})
                self._to_xml(xml, item)
                xml.endElement(item_tag)
        elif isinstance(data, dict):
            for key, value in six.iteritems(data):
                if isinstance(value, (list, tuple)):
                    self._to_xml(xml, value, key)
                else:
                    xml.startElement(key, {})
                    self._to_xml(xml, value, key)
                    xml.endElement(key)
        elif data is None:
            xml.characters('xsi:nil="true"')
        elif isinstance(data, bool):
            xml.characters(str(data).lower())
        else:
            date_time_data = serialize_date_time(data)
            if date_time_data:
                data = date_time_data
            xml.characters(smart_text(data))
