# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals


class BaseSearch(object):
    """Базовый класс для всех видов поиска"""
    def __init__(self, request, query, query_points):
        self.national_version = request.national_version

        self.add_days_mask = query["add_days_mask"]
        self.result_pytz = query["result_pytz"]

        self.point_from = query_points.point_from
        self.point_to = query_points.point_to
        self.departure_date = query_points.departure_date

        self.used_points = set()
        self.segments = []
        self.interval_segments = []

    def add_segment_used_points(self, segment):
        """Добавляем в used_points станции сегмента и их города"""
        self.used_points.add(segment.station_from)
        self.used_points.add(segment.station_to)
        if segment.station_from.settlement:
            self.used_points.add(segment.station_from.settlement)
        if segment.station_to.settlement:
            self.used_points.add(segment.station_to.settlement)

    def search(self):
        raise NotImplementedError
