# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.xgettext.i18n import gettext

from travel.rasp.api_public.api_public.v3.views.json_helpers import point2json
from travel.rasp.api_public.api_public.v3.core.helpers import dt_to_tz_date, get_code_getter
from travel.rasp.api_public.api_public.v3.core.api_errors import ApiError


def get_query_t_type_codes(query):
    return [t.code for t in query["transport_types"]] if query["transport_types"] else None


class BaseScheduler(object):
    def __init__(self, query, station):
        self.station = station
        self.date = dt_to_tz_date(query["dt"], station.pytz)
        self.result_pytz = query["result_pytz"]

        self.event = query["event"]
        if self.event not in ("arrival", "departure", ""):
            raise ApiError(
                gettext("event должен принимать значения arrival, departure или быть пустым."), http_code=400
            )

        code_getter = get_code_getter([station], query["show_systems"])
        self.base_json = {
            "date": self.date,
            "station": point2json(station, code_getter),
        }

    def set_event(self):
        if not self.event:
            self.event = "departure"
        self.base_json["event"] = self.event

    def get_schedule(self):
        raise NotImplementedError

    def schedule2json(self, pagination_json, paginated_schedule):
        raise NotImplementedError
