# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import datetime

from common.views.thread import get_interval_string
from travel.rasp.api_public.api_public.v3.views.json_helpers import Thread2Json


def rasp_db_schedule_route2json(schedule_route, thread_start_date, scheduler):
    json_schedule = {
        "thread": Thread2Json()(schedule_route.thread),
        "is_fuzzy": schedule_route.rtstation.is_fuzzy,
        "platform": schedule_route.rtstation.L_platform(),
        "terminal": None
    }

    shift = schedule_route.rtstation.calc_days_shift(
        event=schedule_route.event, start_date=schedule_route.start_date, event_tz=scheduler.result_pytz
    )
    days_text_dict = schedule_route.thread.L_days_text_dict(
        shift, thread_start_date, next_plan=scheduler.next_plan
    )

    json_schedule["days"] = days_text_dict.get("days_text")
    json_schedule["except_days"] = days_text_dict.get("except_days_text")

    return json_schedule


def schedule_route2json(schedule_route, scheduler):
    json_schedule = rasp_db_schedule_route2json(schedule_route, schedule_route.naive_start_dt.date(), scheduler)
    json_schedule["stops"] = schedule_route.schedule.L_stops() if schedule_route.schedule else ""

    if scheduler.schedule_type == "suburban":
        json_schedule["direction"] = scheduler.schedule.get_direction_title_by_code(
            schedule_route.schedule_item.direction_code
        )

    loc_departure_dt = schedule_route.loc_departure_datetime
    loc_arrival_dt = schedule_route.loc_arrival_datetime

    if scheduler.result_pytz:
        loc_departure_dt = loc_departure_dt.astimezone(scheduler.result_pytz) if loc_departure_dt else None
        loc_arrival_dt = loc_arrival_dt.astimezone(scheduler.result_pytz) if loc_arrival_dt else None

    if not scheduler.date:
        json_schedule["departure"] = loc_departure_dt.time() if loc_departure_dt else None
        json_schedule["arrival"] = loc_arrival_dt.time() if loc_arrival_dt else None
    else:
        json_schedule["departure"] = loc_departure_dt.isoformat() if loc_departure_dt else None
        json_schedule["arrival"] = loc_arrival_dt.isoformat() if loc_arrival_dt else None

    return json_schedule


def interval_schedule_route2json(schedule_route, scheduler):
    json_schedule = rasp_db_schedule_route2json(schedule_route, schedule_route.start_date, scheduler)
    json_schedule["stops"] = ""

    json_schedule["thread"]["interval"] = {
        "density": get_interval_string(schedule_route.thread)
    }

    if not scheduler.date:
        json_schedule["thread"]["interval"].update({
            "begin_time": schedule_route.thread.begin_time,
            "end_time": schedule_route.thread.end_time
        })
    else:
        json_schedule["thread"]["interval"].update({
            "begin_time": datetime.combine(schedule_route.start_date, schedule_route.thread.begin_time).isoformat(),
            "end_time": datetime.combine(schedule_route.start_date, schedule_route.thread.end_time).isoformat()
        })

    return json_schedule
