# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.models.transport import TransportType

from travel.rasp.api_public.api_public.v3.core import points
from travel.rasp.api_public.api_public.v3.views.paginate_view import ApiPaginateView
from travel.rasp.api_public.api_public.v3.request_schemas import ScheduleRequestSchema
from travel.rasp.api_public.api_public.v3.station.baris_scheduler import OneDayBarisScheduler, AllDaysBarisScheduler
from travel.rasp.api_public.api_public.v3.station.rasp_db_scheduler import RaspDbScheduler
from travel.rasp.api_public.api_public.v3.station.base_scheduler import get_query_t_type_codes


class ScheduleView(ApiPaginateView):
    def handle(self, request, *args, **kwargs):
        """
        Ручка станции
        https://st.yandex-team.ru/RASPFRONT-8850
        """
        query, errors = ScheduleRequestSchema(context={"request": request}).load(request.GET)

        station = points.find_point(query["system"], query["station"], station_only=True)
        t_type_codes = get_query_t_type_codes(query)

        if station.t_type.id == TransportType.PLANE_ID and (t_type_codes is None or "plane" in t_type_codes):
            # Станция - аэропорт, и запрашиваем самолеты
            if query["dt"]:
                scheduler = OneDayBarisScheduler(query, station)
            else:
                scheduler = AllDaysBarisScheduler(query, station)
        else:
            # Станция - не аэропорт, или запрашиваем электрички из аэропорта
            scheduler = RaspDbScheduler(query, station, t_type_codes)

        schedule = scheduler.get_schedule()
        pagination_json, paginated_schedule = self.paginate(schedule, request)

        return scheduler.schedule2json(pagination_json, paginated_schedule)
