# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db.models import Q

from common.models.currency import Price
from common.models.tariffs import ThreadTariff


def add_tariffs(segments):
    segments = filter(lambda s: s.t_type.code in ('bus', 'sea', 'river'), segments)

    if segments:
        tariffs_dict = get_tarriffs_dict(segments)

        for segment in segments:
            tariff_key = (segment.thread.uid, segment.station_from.id, segment.station_to.id)

            segment_tariffs = tariffs_dict.get(tariff_key, {})

            if not segment_tariffs:
                continue

            segment_tariff = next(segment_tariffs.iteritems())[1]

            tariff = Price(segment_tariff.tariff, segment_tariff.currency)

            segment.display_info.set_tariff(tariff)


def get_tarriffs_dict(segments):
    query = Q()

    for segment in segments:
        query |= Q(thread_uid=segment.thread.uid,
                   station_from=segment.station_from,
                   station_to=segment.station_to
                   )

    tariffs_dict = {}

    for thread_tariff in ThreadTariff.objects.filter(query):
        tariff_key = (thread_tariff.thread_uid, thread_tariff.station_from_id, thread_tariff.station_to_id)

        tariffs_dict.setdefault(tariff_key, {}).update({thread_tariff.year_days: thread_tariff})

    return tariffs_dict
