# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import math


def fix_currency_code(currency_code):
    if currency_code == 'RUR':
        return 'RUB'

    return currency_code


def get_price_currency(price, currency_info):
    selected = getattr(currency_info, 'selected', None)

    if price.base_value is None or not selected:
        currency = price.currency
        value = price.value

    else:
        currency = selected
        value = price.base_value / currency_info.rates[selected]

    whole = int(math.floor(value))
    cents = int(round((value - whole) * 100))

    json_price_value = {
        'whole': whole,
        'cents': cents
    }

    return json_price_value, fix_currency_code(currency)
