# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import operator
import itertools

from common.views.tariffs import DisplayInfo
from common.models.transport import TransportType

from route_search.models import IntervalRThreadSegment

from travel.rasp.api_public.api_public.v3.tariffs import bus
from travel.rasp.api_public.api_public.v3.tariffs.views import add_station_station_tariffs, add_dynamic_tariffs
from travel.rasp.api_public.api_public.v3.tariffs.utils import rebase_tariffs


def add_tariffs(segments, t_types, point_from, point_to, from_date, currency_info, client_city, national_version):
    segments = list(itertools.ifilterfalse(operator.attrgetter('gone'), segments))

    for segment in segments:
        segment.display_info = DisplayInfo()

    segments = [segment for segment in segments if not isinstance(segment, IntervalRThreadSegment)]

    if not t_types:
        t_types = TransportType.objects.all_cached()

    add_dynamic_tariffs(segments, map(operator.attrgetter('code'), t_types),
                        point_from, point_to, from_date, client_city, national_version)

    add_station_station_tariffs(segments)
    bus.add_tariffs(segments)  # Цены на автобусы и водный транспорт

    rebase_tariffs(segments, currency_info.rates)

    return currency_info
