# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.models.tariffs import Setting


def ufs_cache_timeout():
    """
    Время жизни кеша УФС (сек.)
    """
    return Setting.get('UFS_CACHE_TIMEOUT') * 60


def ufs_empty_timeout():
    """
    Время жизни кеша УФС для пустых результатов и ошибок (сек.)
    """
    return Setting.get('UFS_EMPTY_TIMEOUT') * 60


def rebase_tariffs(segments, rates):
    for segment in segments:
        if segment.gone:
            continue

        places = segment.display_info['tariffs_info'].places

        for place in places:
            place.tariff.rebase(rates)
