# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.api_public.api_public.v3.core import api_errors

from common.data_api.baris.helpers import BarisPseudoUid
from travel.rasp.api_public.api_public.v3.core.helpers import get_search_points
from travel.rasp.api_public.api_public.v3.request_schemas import ThreadInfoRequestSchema
from travel.rasp.api_public.api_public.v3.views.base_api_view import BaseApiView
from travel.rasp.api_public.api_public.v3.thread.json_helpers import get_thread_json, get_interval_thread_json
from travel.rasp.api_public.api_public.v3.thread.baris_thread import get_baris_thread_json
from travel.rasp.api_public.api_public.v3.thread.rasp_db_thread import get_thread


class ThreadInfo(BaseApiView):
    """
    Ручка нитки
    https://st.yandex-team.ru/RASPFRONT-8848
    """
    def handle(self, request, *args, **kwargs):
        query, errors = ThreadInfoRequestSchema(context={"request": request}).load(request.GET)
        result_timezone = query["result_timezone"]
        national_version = request.national_version
        tld = request.tld

        try:
            point_from, point_to = get_search_points(
                query["system_from"], query["system_to"], query["code_from"], query["code_to"]
            )

        except api_errors.ApiError:
            point_from = point_to = None

        pseudo_uid = BarisPseudoUid(query["uid"])
        if pseudo_uid.is_baris_flight:
            return get_baris_thread_json(
                pseudo_uid, query["dt"], point_from, point_to, query["show_systems"]
            )

        else:
            thread, path, naive_start_dt = get_thread(query["uid"], query["dt"])

            if thread.is_interval:
                return get_interval_thread_json(
                    thread, path, naive_start_dt, point_from, point_to,
                    national_version, tld, query["show_systems"], query["currency"],
                    result_timezone=result_timezone, query_dt=query["dt"]
                )

            return get_thread_json(
                thread, path, naive_start_dt, point_from, point_to,
                national_version, tld, query["show_systems"], query["currency"],
                result_timezone=result_timezone
            )
