# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf.urls import url

from travel.rasp.api_public.api_public.v3.views.carrier import CarrierView
from travel.rasp.api_public.api_public.v3.views.copyright import CopyrightView
from travel.rasp.api_public.api_public.v3.nearest.views import NearestStationsView, NearestSettlement
from travel.rasp.api_public.api_public.v3.search.views import SearchView
from travel.rasp.api_public.api_public.v3.station.views import ScheduleView
from travel.rasp.api_public.api_public.v3.views.stations_list import StationsListView
from travel.rasp.api_public.api_public.v3.thread.views import ThreadInfo


urlpatterns = [
    url(r"^search/$", SearchView.as_view()),
    url(r"^thread/$", ThreadInfo.as_view()),
    url(r"^nearest_stations/$", NearestStationsView.as_view()),
    url(r"^nearest_settlement/$", NearestSettlement.as_view()),
    url(r"^schedule/$", ScheduleView.as_view()),
    url(r"^carrier/$", CarrierView.as_view()),
    url(r"^copyright/$", CopyrightView.as_view()),
    url(r"^stations_list/$", StationsListView.as_view())
]
