# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from rest_framework.decorators import api_view

from travel.rasp.api_public.api_public.v3.core.api_response import build_response


def gen_response_error_message(request, error):
    try:
        version = request.path.split('/')[1]
    except IndexError:
        version = None

    return {'error': {
        'text': error.text,
        'http_code': error.http_code,
        'error_code': u'{}_{}_{}'.format(version, settings.PKG_VERSION, error.error_code),
        'request': request.build_absolute_uri(),
    }}, error.http_code


@api_view(['GET', 'POST'])
def error_view(request, error):
    result, http_code = gen_response_error_message(request, error)
    return build_response(request, result, http_code)
