# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rest_framework.pagination import LimitOffsetPagination

from travel.rasp.api_public.api_public.v3.views.base_api_view import BaseApiView


class ApiPaginateView(BaseApiView):
    def handle(self, *args, **kwargs):
        raise NotImplementedError()

    def paginate(self, object_list, request):
        paginator = LimitOffsetPagination()
        paginated_list = paginator.paginate_queryset(object_list, request)
        pagination_json = self.get_pagination_json(paginator)
        return pagination_json, paginated_list

    @staticmethod
    def get_pagination_json(paginator):
        return {
            'total': paginator.count,
            'limit': paginator.limit,
            'offset': paginator.offset,
        }
