# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.utils.translation import get_language
from marshmallow import fields

from common.db.mds.clients import mds_s3_common_client

from travel.rasp.api_public.api_public.v3.views.base_api_view import BaseApiView
from travel.rasp.api_public.api_public.v3.request_schemas import BaseRequestSchema


class StationsListSchema(BaseRequestSchema):
    format = fields.Method(deserialize='get_str_value', missing=u'json')


class StationsListView(BaseApiView):
    def handle(self, request, *args, **kwargs):
        query, errors = StationsListSchema(context={'request': request}).load(request.GET)
        national_version = request.national_version
        lang = get_language()

        raw_data = get_data_from_mds(
            national_version=national_version,
            lang=lang,
            file_format=query['format']
        ).read()

        return raw_data


def get_data_from_mds(national_version, lang, file_format):
    file_name = u'api_public/stations_list_{}_{}.{}'.format(national_version, lang, file_format)
    data = mds_s3_common_client.get_data(key=file_name)

    return data
