#!/usr/bin/env python2
# coding: utf8
from nginx_log_normalize_functions import nginx_log_normalize_uri


# Если в регулярке есть исключающие символы, заводим как кортеж, иначе просто как строку
paths = [
    # Дашборд v3
    (r'v3(\.0)?(\.0)?/search', 'v3/search'),
    (r'v3(\.0)?(\.0)?/thread', 'v3/thread'),
    (r'v3(\.0)?(\.0)?/nearest_stations', 'v3/nearest_stations'),
    (r'v3(\.0)?(\.0)?/nearest_settlement', 'v3/nearest_settlement'),
    (r'v3(\.0)?(\.0)?/schedule', 'v3/schedule'),
    (r'v3(\.0)?(\.0)?/carrier', 'v3/carrier'),
    (r'v3(\.0)?(\.0)?/copyright', 'v3/copyright'),
    (r'v3(\.0)?(\.0)?/stations_list', 'v3/stations_list'),

    # Дашборд v1-v2
    (r'v1(\.0)?(\.0)?/search', 'v1/search'),
    (r'v1(\.0)?(\.0)?/thread', 'v1/thread'),
    (r'v1(\.0)?(\.0)?/nearest_stations', 'v1/nearest_stations'),
    (r'v1(\.0)?(\.0)?/nearest_settlement', 'v1/nearest_settlement'),
    (r'v1(\.0)?(\.0)?/schedule', 'v1/schedule'),
    (r'v1(\.0)?(\.0)?/carrier', 'v1/carrier'),
    (r'v1(\.0)?(\.0)?/copyright', 'v1/copyright'),

    (r'v2(\.0)?(\.0)?/route', 'v2/route'),
]


def nginx_log_normalize_path(uri):
    return nginx_log_normalize_uri(paths, uri)
