# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os

from common.settings import *  # noqa
from common.settings.configuration import BaseConfigurator, Configuration
from common.settings import COMMON_CONTRIB_APPS, COMMON_INSTALLED_APPS
from common.settings.utils import configure_raven, get_app_version
from travel.rasp.library.python.common23.logging.configure import configure_default_logging
from travel.rasp.library.python.common23.logging.qloud import context_extractor


PROJECT_PATH = os.path.abspath(os.path.join(os.path.dirname(__file__), ''))

# используется для запросов к ticketdaemon
PROJECT_CODE = "rasp_api_public"
QUERY_TICKET_DAEMON = False
IGNORE_DAEMON_CACHE = False

LOG_PATH = '/var/log/app'
PACKAGE = 'yandex-rasp-api-public'
PKG_VERSION = get_app_version()

try:
    SUBMODULE_STATUS = open(
        os.path.join(os.path.dirname(__file__), '', 'submodule-status')
    ).read()
except IOError:
    SUBMODULE_STATUS = None

ROOT_URLCONF = 'travel.rasp.api_public.api_public.urls'

# Python dotted path to the WSGI application used by Django's runserver.
WSGI_APPLICATION = 'travel.rasp.api_public.wsgi.application'

APIKEYS_URL = 'http://apikeys-test.paysys.yandex.net:8666/api/'
APIKEYS_SERVICE_TOKEN = 'rasp_7ac1cd95e8d94cbef9e5762c10e1347a'
APIKEYS_ENABLED = False

OPENTRACING_TRACE_ALL = True
OPENTRACING_TRACED_ATTRIBUTES = ['path', 'method']

ALLOWED_HOSTS = ['*']


INSTALLED_APPS = COMMON_CONTRIB_APPS + COMMON_INSTALLED_APPS + [
    'django_opentracing',
    'stationschedule',
    'route_search',
    'raven.contrib.django.raven_compat',
    'rest_framework',
]

MIDDLEWARE_CLASSES = [
    'django_opentracing.OpenTracingMiddleware',
    'travel.library.python.tracing.django.TracingMiddleware',
    'common.middleware.extract_context.ExtractRequestMiddleware',
    'common.middleware.ping.PingResponder',
    'travel.rasp.api_public.api_public.middleware.RedirectToTerminalSlash',
    'travel.rasp.api_public.api_public.middleware.CheckKeyValid',
    'django.middleware.gzip.GZipMiddleware',
    'django.middleware.common.CommonMiddleware',
    'common.middleware.request_activator.RequestActivator',
    'travel.rasp.api_public.api_public.middleware.ApiLanguage',
    'travel.rasp.api_public.api_public.middleware.TuneDummy',
    'common.middleware.host.Host',
    'common.middleware.now.Now',
    'common.geotargeting.middleware.GeoTargeting'
]

GEOTARGETING_DISABLE_REDIRECT_PREFIXES = '/'

SECRET_SALT = 'b1818c0846d2bb22b30e17b6dbd678be'

API_LANGUAGES = ['ru', 'tr', 'uk', 'en']

COUNTRY_ISO_TO_TLD = {
    'TR': 'com.tr',
    'RU': 'ru',
    'UA': 'ua',
    'KZ': 'kz',
    'BY': 'by',
}

TLD_TO_GEO_ID = {
    'ru': 225,
    'com.tr': 983,
    'ua': 187,
    'by': 149,
    'kz': 159,
}

assert set(COUNTRY_ISO_TO_TLD.values()) == set(TLD_TO_GEO_ID.keys())

COUNTRY_ISO_TO_NATIONAL_VERSION = {
    'TR': 'tr',
    'RU': 'ru',
    'UA': 'ua',
}

THREAD_BATCH_REQUEST_LIMIT = 20


def with_suffix(suffix, prefixes):
    return [prefix + suffix for prefix in prefixes]


PRECACHE = with_suffix('.objects.precache', [
    'common.models.geo:StationType',
    'common.models.geo:StationMajority',
    'common.models.transport:TransportType',
    'common.models.transport:TransportModel',
    'common.models.geo:Country',
    'common.models.geo:Region',
    'common.models.geo:Settlement',
    'common.models.geo:StationTerminal',
    'common.models.schedule:RThreadType',
    'common.models.schedule:Supplier',

    'common.models.geo:Direction',
    'common.models.geo:ExternalDirection',
    'common.models.tariffs:SuburbanTariff',
    'common.models.tariffs:TariffType',
    'common.models.schedule:Company',
    'common.models.geo:CodeSystem',
    'common.models.tariffs:Setting',
    'common.models.schedule:PlatformTranslation',
    'common.models.geo:DirectionTranslate',
    'common.models.geo:DirectionFromTranslate'

])

renders = ['rest_framework.renderers.JSONRenderer',
           'travel.rasp.api_public.api_public.v3.rest_utils.ApiXMLRender',
           'rest_framework.renderers.BrowsableAPIRenderer',
           'rest_framework.renderers.StaticHTMLRenderer']

RENDERS_DICT = dict(zip(['json', 'xml', 'debug', 'html'], range(len(renders))))

ACCEPT_TYPES = {'application/json': 'json',
                'application/xml': 'xml'}

REST_FRAMEWORK = {
    'DEFAULT_CONTENT_NEGOTIATION_CLASS': 'travel.rasp.api_public.api_public.v3.rest_utils.IgnoreClientContentNegotiation',
    'DEFAULT_RENDERER_CLASSES': renders,
    'URL_FORMAT_OVERRIDE': 'debug',
    'PAGE_SIZE': 100
}


PYLOGCTX_REQUEST_EXTRACTOR = context_extractor


class APIConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        base_log_level = os.environ.get('RASP_BASE_LOG_LEVEL', 'INFO')
        format_with_context = '%(levelname)s %(asctime)s %(context)s %(process)d %(name)s %(message)s'
        settings['LOGGING'] = configure_default_logging(settings, base_log_level, format_with_context, jaeger_tracing=True)

    def apply_production(self, settings):
        settings['APIKEYS_URL'] = 'http://apikeys-ipv6.yandex.net:8666/api/'
        settings['APIKEYS_ENABLED'] = True

        configure_raven(settings, 'api_public')

        settings['PROMOSEYAHAT_URL'] = 'http://promo.seyahat.yandex.net'

    def apply_testing(self, settings):
        settings['APIKEYS_URL'] = 'http://apikeys-test.paysys.yandex.net:8666/api/'
        settings['APIKEYS_ENABLED'] = True

        settings['ADMINS'] = (('Rasp Testing', 'rasp-testing@yandex-team.ru'), )

        configure_raven(settings, 'api_public')

    def apply_stress(self, settings):
        settings['APIKEYS_ENABLED'] = False


Configuration.configurator_classes += [APIConfigurator]
