# -*- coding: utf-8 -*-

import operator
import itertools

from common.views.tariffs import DisplayInfo
from common.models.transport import TransportType

from travel.rasp.api_public.tariffs import bus
from travel.rasp.api_public.tariffs.views import add_station_station_tariffs, add_dynamic_tariffs
from travel.rasp.api_public.tariffs.utils import rebase_tariffs


def add_tariffs(segments, query, request, currency_info):
    segments = list(itertools.ifilterfalse(operator.attrgetter('gone'), segments))

    for segment in segments:
        segment.display_info = DisplayInfo()

    t_types = query.t_types

    if not t_types:
        t_types = TransportType.objects.all_cached()

    add_dynamic_tariffs(segments, map(operator.attrgetter('code'), t_types),
                        query.point_from, query.point_to, query.date, request)

    add_station_station_tariffs(segments)
    bus.add_tariffs(segments)  # Цены на автобусы и водный транспорт

    rebase_tariffs(segments, currency_info.rates)

    return currency_info
