PY2_LIBRARY()

OWNER(g:rasp-back)

PEERDIR(
    contrib/python/djangorestframework-xml
    contrib/python/django-debug-toolbar
    contrib/python/inflect
    contrib/python/ipython

    travel/library/python/tracing/django
    travel/library/python/tracing/gunicorn
    travel/library/python/tracing/instrumentation

    travel/library/python/entrypoint

    travel/rasp/library/python/common
    travel/rasp/library/python/route_search
    travel/rasp/library/python/stationschedule
    travel/rasp/library/python/tracing

    travel/library/python/dev/pydevd_inject
)

PY_SRCS(
    TOP_LEVEL
    settings.py
)

PY_SRCS(
    app.py
    gunicorn_conf.py
    wsgi.py

    docker/local_settings.py

    tariffs/retrieving/__init__.py
    tariffs/retrieving/base.py
    tariffs/__init__.py
    tariffs/bus.py
    tariffs/shortcuts.py
    tariffs/utils.py
    tariffs/views.py

    api_public/__init__.py
    api_public/geobase_helpers.py
    api_public/middleware.py

    api_public/old_versions/__init__.py
    api_public/old_versions/core/__init__.py
    api_public/old_versions/core/api_context.py
    api_public/old_versions/core/api_errors.py
    api_public/old_versions/core/api_response.py
    api_public/old_versions/core/apikeys.py
    api_public/old_versions/core/decorators.py
    api_public/old_versions/core/external_urls.py
    api_public/old_versions/core/helpers.py
    api_public/old_versions/core/json_helpers.py
    api_public/old_versions/core/points.py
    api_public/old_versions/core/train_schedule.py
    api_public/old_versions/core/utils/__init__.py
    api_public/old_versions/core/utils/currency.py
    api_public/old_versions/core/utils/dict2xml/__init__.py
    api_public/old_versions/core/utils/dict2xml/logic.py
    api_public/old_versions/core/views/__init__.py
    api_public/old_versions/core/views/carrier.py
    api_public/old_versions/core/views/nearest.py
    api_public/old_versions/core/views/station_schedule.py
    api_public/old_versions/core/views/thread.py

    api_public/old_versions/v1/__init__.py
    api_public/old_versions/v1/json_helpers.py
    api_public/old_versions/v1/urls.py
    api_public/old_versions/v1/views.py

    api_public/old_versions/v2/routes_info.py
    api_public/old_versions/v2/urls.py

    api_public/urls.py

    api_public/v3/core/api_errors.py
    api_public/v3/core/api_response.py
    api_public/v3/core/apikeys.py
    api_public/v3/core/helpers.py
    api_public/v3/core/points.py

    api_public/v3/nearest/data_layer.py
    api_public/v3/nearest/external_urls.py
    api_public/v3/nearest/views.py

    api_public/v3/request_schemas.py
    api_public/v3/rest_utils.py

    api_public/v3/search/baris_search.py
    api_public/v3/search/baris_segments.py
    api_public/v3/search/base_search.py
    api_public/v3/search/helpers.py
    api_public/v3/search/rasp_db_json_helpers.py
    api_public/v3/search/rasp_db_search.py
    api_public/v3/search/transfers_search.py
    api_public/v3/search/views.py

    api_public/v3/station/baris_scheduler.py
    api_public/v3/station/base_scheduler.py
    api_public/v3/station/rasp_db_json_helpers.py
    api_public/v3/station/rasp_db_scheduler.py
    api_public/v3/station/views.py

    api_public/v3/tariffs/__init__.py
    api_public/v3/tariffs/bus.py
    api_public/v3/tariffs/currency.py
    api_public/v3/tariffs/retrieving/__init__.py
    api_public/v3/tariffs/retrieving/base.py
    api_public/v3/tariffs/shortcuts.py
    api_public/v3/tariffs/utils.py
    api_public/v3/tariffs/views.py

    api_public/v3/thread/baris_thread.py
    api_public/v3/thread/json_helpers.py
    api_public/v3/thread/rasp_db_thread.py
    api_public/v3/thread/views.py

    api_public/v3/urls.py

    api_public/v3/views/base_api_view.py
    api_public/v3/views/carrier.py
    api_public/v3/views/copyright.py
    api_public/v3/views/error_view.py
    api_public/v3/views/json_helpers.py
    api_public/v3/views/paginate_view.py
    api_public/v3/views/stations_list.py
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)
