# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import requests

from travel.rasp.library.python.common23.utils.exceptions import SimpleUnicodeException

from travel.library.python.tracing.instrumentation import traced_function


class ConnectionError(SimpleUnicodeException):
    pass


class BaseClient(object):
    def __init__(self, log, url=None, api_timeout=None, verify_ssl=None):
        self._log = log
        self._url = url
        self._api_timeout = api_timeout
        self._verify_ssl = verify_ssl

    def make_response_and_cache_timeout(self, query):
        raise NotImplementedError

    def _make_params(self, query):
        raise NotImplementedError

    @traced_function
    def _get_raw_response(self, query):
        params = self._make_params(query)
        try:
            response = requests.get(
                self._url, params=params, timeout=self._api_timeout, verify=self._verify_ssl
            )
        except Exception:
            msg = 'Ошибка при запросе к {}'.format(self._url)
            self._log.exception(msg)
            raise ConnectionError(msg)
        self._log.info('Request: {}, response code: {}'.format(
            response.request.url,
            response.status_code,
        ))
        return response
