# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from future import standard_library
standard_library.install_aliases()
from urllib.parse import unquote

from marshmallow import post_load, pre_load, fields

from travel.rasp.library.python.common23.models.serialization.common_schemas import PriceSchema
from travel.rasp.library.python.common23.models.serialization.compat import Schema


class BlablacarV3ResponseParseError(Exception):
    pass


class FixedPriceSchema(PriceSchema):
    @pre_load
    def fix_amount_to_value(self, data, **kwargs):
        data['value'] = float(data.pop('amount', 0))
        return data


class Trip(object):
    def __init__(self, price, duration_in_seconds):
        self.price = price
        self.duration_in_seconds = duration_in_seconds


class TripSchema(Schema):
    price = fields.Nested(FixedPriceSchema)
    duration_in_seconds = fields.Integer()

    @post_load
    def make_trip_object(self, data, **kwargs):
        return Trip(**data)


class SearchInfo(object):
    def __init__(self, count, full_trip_count):
        self.count = count - full_trip_count


class SearchInfoSchema(Schema):
    count = fields.Integer()
    full_trip_count = fields.Integer()

    @post_load
    def make_search_info_object(self, data, **kwargs):
        return SearchInfo(**data)


class BlablacarV3Response(object):
    def __init__(self, link, trips, search_info):
        self.link = unquote(link.encode('utf8'))
        self.trips = trips
        self.search_info = search_info


class BlablacarV3ResponseSchema(Schema):
    link = fields.String()
    trips = fields.List(fields.Nested(TripSchema), default=[])
    search_info = fields.Nested(SearchInfoSchema)

    @post_load
    def make_response_object(self, data, **kwargs):
        if not data:
            raise BlablacarV3ResponseParseError
        return BlablacarV3Response(**data)
