# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from travel.rasp.library.python.common23.dynamic_settings.default import conf

from travel.rasp.blablacar.blablacar.clients.tariff import BlablacarTariff, get_thread_title, make_order_url
from travel.rasp.blablacar.blablacar.const import (
    BLABLACAR_ALL_DAYS_DATE, EMPTY_TRACKING_PARAMS, TOUCH_TRACKING_PARAMS, TRACKING_PARAMS
)


log = logging.getLogger(__name__)


def create_response(response, query):
    if not response.trips:
        log.error('Unknown direction in blablacar')
        return None, 'unknown_direction'

    if response.search_info.count < conf.BLABLACAR_MIN_OFFERS_COUNT:
        log.info('total_trip_count < BLABLACAR_MIN_OFFERS_COUNT: {} < {}'.format(
            response.search_info.count,
            conf.BLABLACAR_MIN_OFFERS_COUNT
        ))
        return None, 'not_enough_trips'

    trip = response.trips[0]
    national_version = query.national_version if query.national_version in TRACKING_PARAMS else 'ru'
    if need_to_return_empty_tariff(response, query.date):
        extra_params = EMPTY_TRACKING_PARAMS.get(national_version, EMPTY_TRACKING_PARAMS['ru'])
        extra_params['seats'] = 0
    else:
        tracking_params = TOUCH_TRACKING_PARAMS if query.is_touch else TRACKING_PARAMS
        extra_params = tracking_params[national_version]
        extra_params['seats'] = 1
    order_url = make_order_url(
        base_url=response.link,
        extra_params=extra_params
    )
    tariff = BlablacarTariff(
        title=get_thread_title(query.point_from, query.point_to),
        duration=trip.duration_in_seconds,
        number_of_variants=response.search_info.count,
        price=trip.price,
        order_url=order_url
    )
    return tariff, None


def need_to_return_empty_tariff(response, query_date):
    if response.search_info.count > 0:
        return False
    if not query_date or query_date == BLABLACAR_ALL_DAYS_DATE:
        return False
    return True
