# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.blablacar.blablacar.clients.base_client import BaseClient
from travel.rasp.blablacar.blablacar.clients.blablacar_v3.client import BlablacarV3Client
from travel.rasp.blablacar.blablacar.clients.edem_rf.client import EdemRfClient
from travel.rasp.blablacar.blablacar.const import CarProvider


CLIENT_BY_PROVIDER = {
    CarProvider.BLABLACAR: BlablacarV3Client(),
    CarProvider.EDEM_RF: EdemRfClient()
}


def get_client_by_provider(provider):
    # type: (CarProvider) -> BaseClient

    client = CLIENT_BY_PROVIDER.get(provider)  # type: BaseClient
    if client is None:
        raise Exception('No client by this provider: {}'.format(provider))
    return client
