# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from rest_framework import status

from travel.rasp.library.python.common23.settings.utils import define_setting
from rasp_vault.api import get_secret


BLABLACAR_API_KEY = get_secret('rasp-common.BLABLACAR_API_KEY', secret_stub='blablacar_api_key')


define_setting('EDEM_RF_API_TIMEOUT', default=3)
define_setting('EDEM_RF_VERIFY_SSL', default=True)
define_setting('EDEM_RF_SUCCESS_CACHE_TIMEOUT', default=(60 * 30), converter=lambda x: int(x))
define_setting('EDEM_RF_ERROR_CACHE_TIMEOUT', default=(60 * 30), converter=lambda x: int(x))

define_setting('BLABLACAR_API_TIMEOUT', default=3, converter=lambda x: float(x))
define_setting('BLABLACAR_VERIFY_SSL', default=True)
define_setting('BLABLACAR_ERROR_CACHE_TIMEOUT', default=(60 * 5), converter=lambda x: int(x))
define_setting('BLABLACAR_SUCCESS_CACHE_TIMEOUT', default=(60 * 5), converter=lambda x: int(x))
define_setting('BLABLACAR_TOO_MANY_REQUESTS_CACHE_TIMEOUT', default=60, converter=lambda x: int(x))


EDEM_RF_PROCESSING_ERRORS = {
    'communication_error': {
        'data': {'error': 'Communication with edem_rf error'},
        'status': status.HTTP_502_BAD_GATEWAY,
        'cache_timeout': settings.EDEM_RF_ERROR_CACHE_TIMEOUT
    },
    'bad_response': {
        'data': {'error': 'Bad status of edem_rf response'},
        'status': status.HTTP_502_BAD_GATEWAY,
        'cache_timeout': settings.EDEM_RF_ERROR_CACHE_TIMEOUT
    },
    'unparseable_response': {
        'data': {'error': 'Unparseable edem_rf response'},
        'status': status.HTTP_500_INTERNAL_SERVER_ERROR,
        'cache_timeout': settings.EDEM_RF_ERROR_CACHE_TIMEOUT
    }
}

BLABLACAR_PROCESSING_ERRORS = {
    'communication_error': {
        'data': {'error': 'Communication with blablacar error'},
        'status': status.HTTP_502_BAD_GATEWAY,
        'cache_timeout': settings.BLABLACAR_ERROR_CACHE_TIMEOUT
    },
    'bad_response': {
        'data': {'error': 'Bad status'},
        'status': status.HTTP_502_BAD_GATEWAY,
        'cache_timeout': settings.BLABLACAR_ERROR_CACHE_TIMEOUT
    },
    'unparseable_response': {
        'data': {'error': 'Unparseable blablacar response'},
        'status': status.HTTP_500_INTERNAL_SERVER_ERROR,
        'cache_timeout': settings.BLABLACAR_ERROR_CACHE_TIMEOUT
    },
    'unknown_direction': {
        # blablacar не знает данное направление, их ссылка ведёт на страницу "Упс. Такой страницы не существует."
        # => возвращаем 404, чтобы показать рекламу
        'data': {'error': 'Unknown direction in blablacar'},
        'status': status.HTTP_404_NOT_FOUND,
        'cache_timeout': settings.BLABLACAR_ERROR_CACHE_TIMEOUT
    },
    'not_enough_trips': {
        'data': {'error': 'not_enough_trips in blablacar'},
        'status': status.HTTP_428_PRECONDITION_REQUIRED,
        'cache_timeout': settings.BLABLACAR_ERROR_CACHE_TIMEOUT
    },
}

BLABLACAR_SPECIAL_ERRORS_BY_STATUS_CODE = {
    status.HTTP_429_TOO_MANY_REQUESTS: {
        'data': {'error': 'Too many requests to blablacar'},
        'status': status.HTTP_429_TOO_MANY_REQUESTS,
        'cache_timeout': settings.BLABLACAR_TOO_MANY_REQUESTS_CACHE_TIMEOUT
    },
}
