# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import fields, pre_load
from travel.rasp.library.python.common23.models.serialization.compat import Schema


class EdemRfRouteSchema(Schema):
    duration = fields.Integer()
    cost = fields.Integer()

    @pre_load
    def get_int_values(self, data, **kwargs):
        data['duration'] = int(data['duration'])
        data['cost'] = int(data['cost'])
        return data


class EdemRfDataSchema(Schema):
    search_url = fields.String(data_key='searchUrl')
    routes = fields.Nested(EdemRfRouteSchema, many=True)


class EdemRfResponseSchema(Schema):
    success = fields.Boolean()
    edem_rf_data = fields.Nested(EdemRfDataSchema, data_key='data')
