# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.library.python.common23.models.currency.price import Price

from travel.rasp.blablacar.blablacar.clients.tariff import BlablacarTariff, get_thread_title, make_order_url
from travel.rasp.blablacar.blablacar.const import TOUCH_TRACKING_PARAMS, TRACKING_PARAMS


def create_response(edem_rf_response, query):
    edem_rf_data = edem_rf_response['edem_rf_data']
    routes = edem_rf_data.get('routes', [])
    min_cost = None
    min_duration = None
    for route in routes:
        duration = int(route['duration'])
        cost = float(route['cost'])
        if not min_duration or duration < min_duration:
            min_duration = duration
        if not min_cost or cost < min_cost:
            min_cost = cost

    edem_url = edem_rf_data.get('search_url')
    if edem_url:
        tracking_params = TOUCH_TRACKING_PARAMS if query.is_touch else TRACKING_PARAMS
        national_version = query.national_version if query.national_version in TRACKING_PARAMS else 'ru'
        extra_params = tracking_params.get(national_version, tracking_params['ru'])
        order_url = make_order_url(
            base_url=edem_url,
            extra_params=extra_params
        )
    else:
        order_url = None

    return BlablacarTariff(
        title=get_thread_title(query.point_from, query.point_to),
        order_url=order_url,
        number_of_variants=len(routes),
        duration=min_duration,
        price=Price(min_cost, 'RUB')
    )
