# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from future import standard_library
standard_library.install_aliases()
from urllib.parse import urlsplit, SplitResult

from django.http import QueryDict

from travel.rasp.library.python.common23.models.core.geo.settlement import Settlement
from travel.rasp.library.python.common23.models.core.geo.title_generator import DASH


# Исключения для наименований населенных пунктов в Blablacar (для используемого ими парсера google):
# эти наименования передаем без префикса (например, без "г."), т.к. иначе парсер не понимает
NO_PREFIX_SETTLEMENTS = [Settlement.KRASNODAR_ID]


class BlablacarTariff(object):
    def __init__(self, title, duration, number_of_variants, price, order_url):
        self.title = title
        self.duration = duration
        self.number_of_variants = number_of_variants
        self.price = price
        self.order_url = order_url

    def to_response(self):
        return {
            'offersCount': self.number_of_variants,
            'price': {
                'currency': self.price.currency,
                'value': self.price.value
            },
            'orderUrl': self.order_url,
            'title': self.title,
            'duration': self.duration,
        }


def make_order_url(base_url, extra_params=None):
    url_parts = urlsplit(base_url)
    url_params = QueryDict(url_parts.query, mutable=True)
    url_params.update(extra_params)
    return SplitResult(url_parts.scheme, url_parts.netloc, url_parts.path, url_params.urlencode(), '').geturl()


def get_thread_title(point_from, point_to):
    city_from = _get_settlement(point_from)
    title_from = city_from.L_title() if city_from else _get_point_title(point_from)

    city_to = _get_settlement(point_to)
    title_to = city_to.L_title() if city_to else _get_point_title(point_to)

    return '{title_from} {dash} {title_to}'.format(title_from=title_from, title_to=title_to, dash=DASH)


def _get_point_title(point):
    omonim_title = point.L_omonim_title(show_district=False)
    if type(point) == Settlement and point.id in NO_PREFIX_SETTLEMENTS:
        omonim_title['title'] = point.L_title()
    return '{title}, {add}'.format(**omonim_title) if omonim_title['add'] else omonim_title['title']


def _get_settlement(point):
    return point if isinstance(point, Settlement) else getattr(point, 'settlement', None)
