# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import date


class CarProvider(object):
    BLABLACAR = 'blablacar'
    BLABLACAR_V3 = 'blablacar_v3'
    EDEM_RF = 'edem_rf'

    ALL = {BLABLACAR, BLABLACAR_V3, EDEM_RF}
    BLABLACAR_PROVIDERS = {BLABLACAR, BLABLACAR_V3}


# Фиктивная дата для поиска блаблакара "на все дни".
BLABLACAR_ALL_DAYS_DATE = date(2100, 1, 1)

BLABLACAR_NATIONAL_SETTINGS = {
    'ru': {
        'locale': 'ru_RU',
        'blablacar_currency': 'RUB',
        'rasp_currency': 'RUR',
        'redirect_base_url': 'https://www.blablacar.ru/search?',
        'redirect_base_m_url': 'https://m.blablacar.ru/search?',
    },
    'ua': {
        'locale': 'uk_UA',
        'blablacar_currency': 'UAH',
        'rasp_currency': 'UAH',
        'redirect_base_url': 'https://www.blablacar.com.ua/search?',
        'redirect_base_m_url': 'https://m.blablacar.com.ua/search?',
    }
}

TRACKING_PARAMS = {
    'ru': {
        'utm_source': 'YANDEXRASP',
        'utm_medium': 'API',
        'utm_campaign': 'RU_YANDEXRASP_PSGR_TIMETABLE_none',
        'comuto_cmkt': 'RU_YANDEXRASP_PSGR_TIMETABLE_none',
    },
    'ua': {
        'utm_source': 'YANDEXRASP',
        'utm_medium': 'API',
        'utm_campaign': 'UA_YANDEXRASP_PSGR_TIMETABLE_none',
        'comuto_cmkt': 'UA_YANDEXRASP_PSGR_TIMETABLE_none',
    }
}
EMPTY_TRACKING_PARAMS = {
    'ru': {
        'utm_source': 'YANDEXRASP',
        'utm_medium': 'API',
        'utm_campaign': 'RU_YANDEXRASP_PSGR_NOOFEERS_none',
        'comuto_cmkt': 'RU_YANDEXRASP_PSGR_NOOFEERS_none',
    },
    'ua': {
        'utm_source': 'YANDEXRASP',
        'utm_medium': 'API',
        'utm_campaign': 'UA_YANDEXRASP_PSGR_NOOFEERS_none',
        'comuto_cmkt': 'UA_YANDEXRASP_PSGR_NOOFEERS_none',
    }
}
TOUCH_TRACKING_PARAMS = {
    'ru': {
        'utm_source': 'YANDEXRASP',
        'utm_medium': 'API',
        'utm_campaign': 'RU_YANDEXRASP_PSGR_TRASP_none',
        'comuto_cmkt': 'RU_YANDEXRASP_PSGR_TRASP_none',
    },
    'ua': {
        'utm_source': 'YANDEXRASP',
        'utm_medium': 'API',
        'utm_campaign': 'UA_YANDEXRASP_PSGR_TRASP_none',
        'comuto_cmkt': 'UA_YANDEXRASP_PSGR_TRASP_none',
    }
}
