# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from travel.rasp.library.python.common23.settings.utils import define_setting
from travel.rasp.library.python.common23.utils.exceptions import SimpleUnicodeException
from travel.rasp.library.python.common23.utils.geo import GreatCircleCalculationError, great_circle_distance_km


define_setting('BLABLACAR_MIN_DISTANCE_KM', default=75, converter=lambda x: float(x))
define_setting('BLABLACAR_MAX_DISTANCE_KM', default=2000, converter=lambda x: float(x))


class BlablacarDistanceError(SimpleUnicodeException):
    pass


def check_blablacar_distance(point_from, point_to, minimal_distance):
    try:
        distance_km = great_circle_distance_km(point_from, point_to)
    except GreatCircleCalculationError:
        raise BlablacarDistanceError("Can't calculate distance between points")
    else:
        if distance_km > settings.BLABLACAR_MAX_DISTANCE_KM:
            raise BlablacarDistanceError('Too much distance between points')
        elif distance_km < minimal_distance:
            raise BlablacarDistanceError('Too small distance between points')
    return distance_km
