# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.conf import settings
from django.core.cache import caches
from django.core.cache.backends.base import DEFAULT_TIMEOUT

from travel.rasp.blablacar.blablacar.clients.client_factory import get_client_by_provider
from travel.rasp.blablacar.blablacar.serialization import BlablacarQuery
from travel.rasp.blablacar.blablacar.service.response_prototype import ResponsePrototype
from travel.rasp.blablacar.blablacar.worker import Worker


log = logging.getLogger(__name__)

BANNED_RESPONSE = ResponsePrototype({'querying': False, 'banned': True, 'tariff': {}})
EMPTY_POLL_RESPONSE = ResponsePrototype({'querying': False, 'banned': False, 'tariff': {}})
EMPTY_QUERYING_RESPONSE = ResponsePrototype({'querying': True, 'banned': False, 'tariff': {}})


def get_blablacar_cache():
    return caches[settings.BLABLACAR_CACHE_CLUSTER_ALIAS]


def process_find_routes_query(query, poll):
    # type: (BlablacarQuery, bool) -> ResponsePrototype

    response = get_blablacar_cache().get(query.key)
    if response is not None:
        return response
    if poll:
        return EMPTY_POLL_RESPONSE

    get_blablacar_cache().set(query.key, EMPTY_QUERYING_RESPONSE, timeout=DEFAULT_TIMEOUT)

    worker = Worker(target=update_response_in_cache, args=(query,))
    worker.start_daemon()

    return EMPTY_QUERYING_RESPONSE


def update_response_in_cache(query):
    # type: (BlablacarQuery) -> None

    try:
        client = get_client_by_provider(query.provider)
        response, cache_timeout = client.make_response_and_cache_timeout(query)
    except Exception:
        log.exception('Ошибка при обработке запроса %r', query.key)
        get_blablacar_cache().delete(query.key)
    else:
        get_blablacar_cache().set(query.key, response, timeout=cache_timeout)
