# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rest_framework.response import Response


class ResponsePrototype(object):
    # restframework Response не пиклится по умолчанию
    def __init__(
        self,
        data=None,
        status=None,
        template_name=None,
        headers=None,
        exception=False,
        content_type=None
    ):
        self.data = data
        self.template_name = template_name
        self.exception = exception
        self.status = status
        self.headers = headers
        self.content_type = content_type

    def build_response(self):
        return Response(
            data=self.data,
            status=self.status,
            template_name=self.template_name,
            headers=self.headers,
            exception=self.exception,
            content_type=self.content_type
        )


def build_error_response_and_cache_timeout(error_params):
    return (
        ResponsePrototype(error_params['data'], status=error_params['status']),
        error_params['cache_timeout']
    )
