# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.library.python.common23.models.core.geo.country import Country
from travel.rasp.library.python.common23.models.core.geo.region import Region


def country_id_of(point):
    return point.id if isinstance(point, Country) else point.country_id


def region_id_of(point):
    return point.id if isinstance(point, Region) else point.region_id


def is_direction_banned(point_from, point_to):
    """
    Check restriction of Crimea and not Russia according with [RASPFRONT-7674]
    """

    if region_id_of(point_from) == Region.CRIMEA_REGION_ID:
        return True

    if region_id_of(point_to) == Region.CRIMEA_REGION_ID:
        return True

    if country_id_of(point_from) != Country.RUSSIA_ID and country_id_of(point_to) != Country.RUSSIA_ID:
        return True

    return False


def is_settlement_banned(settlement):
    """
    Check restriction of Crimea and not Russia according with [RASPFRONT-7674]
    """

    if settlement.country_id != Country.RUSSIA_ID:
        return True

    if settlement.region_id == Region.CRIMEA_REGION_ID:
        return True

    return False
