# coding: utf-8
import threading

from django.db import connection
from ylog.context import get_log_context, log_context


class Worker(threading.Thread):
    def run(self):
        with log_context(bgthread='yes', **self.prev_context):
            super(Worker, self).run()
            connection.close()

    def start_daemon(self):
        self.prev_context = get_log_context()
        self.daemon = True
        self.start()
