PY3_LIBRARY(blablacar)
OWNER(g:rasp-back)

PEERDIR(
    contrib/python/protobuf
    contrib/python/cached-property
    contrib/python/gunicorn
    contrib/python/ipython

    travel/library/python/rasp_vault
    travel/library/python/tracing/django
    travel/library/python/tracing/gunicorn
    travel/library/python/tracing/instrumentation

    travel/rasp/library/python/common23/date
    travel/rasp/library/python/common23/data_api/error_booster
    travel/rasp/library/python/common23/db
    travel/rasp/library/python/common23/db/mongo
    travel/rasp/library/python/common23/db/redis
    travel/rasp/library/python/common23/dynamic_settings
    travel/rasp/library/python/common23/logging
    travel/rasp/library/python/common23/logging/mongo
    travel/rasp/library/python/common23/middleware
    travel/rasp/library/python/common23/models/core
    travel/rasp/library/python/common23/models/currency
    travel/rasp/library/python/common23/models/fields
    travel/rasp/library/python/common23/models/precache
    travel/rasp/library/python/common23/models/serialization
    travel/rasp/library/python/common23/models/tariffs
    travel/rasp/library/python/common23/models/texts
    travel/rasp/library/python/common23/models/transport
    travel/rasp/library/python/common23/models/utils
    travel/rasp/library/python/common23/server
    travel/rasp/library/python/common23/settings
    travel/rasp/library/python/common23/utils
    travel/rasp/library/python/common23/utils_db
    travel/rasp/library/python/common23/xgettext

    travel/rasp/library/python/tracing
)

PY_SRCS(
    TOP_LEVEL
    settings.py
)

PY_SRCS(
    app.py
    gunicorn_conf.py
    urls.py
    wsgi.py
    docker/local_settings.py

    blablacar/__init__.py
    blablacar/app.py
    blablacar/data_layer.py
    blablacar/const.py
    blablacar/serialization.py
    blablacar/views.py
    blablacar/worker.py

    blablacar/clients/blablacar_v3/client.py
    blablacar/clients/blablacar_v3/serialization.py
    blablacar/clients/blablacar_v3/tariff.py
    blablacar/clients/edem_rf/client.py
    blablacar/clients/edem_rf/serialization.py
    blablacar/clients/edem_rf/tariff.py
    blablacar/clients/base_client.py
    blablacar/clients/client_factory.py
    blablacar/clients/const.py
    blablacar/clients/tariff.py

    blablacar/service/__init__.py
    blablacar/service/distance.py
    blablacar/service/query_and_cache.py
    blablacar/service/response_prototype.py
    blablacar/service/restriction.py
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    blablacar/tests
)

