from flask_admin.contrib.sqla import ModelView

from travel.rasp.bus.admin.app.views.principal import PrincipalViewMixin


class CarrierView(PrincipalViewMixin, ModelView):
    can_create = True
    can_delete = True

    column_searchable_list = (
        'legal_name', 'first_name', 'middle_name', 'last_name',
    )

    column_list = (
        'id',
        'register_type', 'register_number', 'inn',
        'legal_name', 'last_name', 'first_name', 'middle_name',
        'actual_address', 'legal_address', 'timetable', 'hidden',
        'created_at', 'updated_at',
    )

    column_labels = {
        'id': 'id',
        'register_type': 'Рег. тип',
        'register_number': 'Рег. номер',
        'inn': 'ИНН',
        'legal_name': 'Юридическое название',
        'actual_address': 'Фактический адрес',
        'legal_address': 'Юридический адрес',
        'timetable': 'Время работы',
        'first_name': 'Имя',
        'middle_name': 'Отчество',
        'last_name': 'Фамилия',
        'hidden': 'Скрыт',
        'created_at': 'Время создание',
        'updated_at': 'Время обновления',
    }
    form_excluded_columns = ('name', 'created_at', 'updated_at',)
