from flask_admin.contrib.sqla import ModelView

from travel.rasp.bus.admin.app.views.principal import PrincipalViewMixin


class CarrierMatchingView(PrincipalViewMixin, ModelView):
    can_create = True
    can_delete = True
    column_display_pk = True
    column_list = ('id', 'supplier', 'code', 'carrier',)
    column_labels = {
        'id': 'id',
        'supplier': 'Поставщик',
        'code': 'Код',
        'carrier': 'Перевозчик',
    }
    form_excluded_columns = ('created_at', 'updated_at',)
